/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class MapIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Map.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty arbitraryProperty = context.getArbitraryProperty();
        ContainerProperty containerProperty = arbitraryProperty.getContainerProperty();
        Property property = arbitraryProperty.getObjectProperty().getProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container arbitraryProperty should not null. property : " + property.getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<Arbitrary<?>> childrenArbitraries = context.getChildrenArbitraryContexts().getArbitraries();
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(HashMap::new);
        for (Arbitrary<?> child : childrenArbitraries) {
            builderCombinator = builderCombinator.use(child).in((map, value) -> {
                MapEntryElementProperty.MapEntryElementType entryElement = (MapEntryElementProperty.MapEntryElementType)value;
                if (entryElement.getKey() == null) {
                    throw new IllegalArgumentException("Map key cannot be null.");
                }
                map.put(entryElement.getKey(), entryElement.getValue());
                return map;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(map -> {
            context.evictUnique(context.getPathProperty());
            return map;
        }));
    }
}

