/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.unique.FilteredMonkeyArbitrary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class SetIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Set.class);
    private static final int MAX_TRIES = 10000;

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty arbitraryProperty = context.getArbitraryProperty();
        ContainerProperty containerProperty = arbitraryProperty.getContainerProperty();
        Property property = arbitraryProperty.getObjectProperty().getProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container arbitraryProperty should not null. property : " + property.getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List childrenArbitraries = context.getChildrenArbitraryContexts().getArbitraries().stream().map(arbitrary -> new FilteredMonkeyArbitrary<Object>((Arbitrary<Object>)arbitrary, it -> context.isUniqueAndCheck(context.getPathProperty(), it), 10000)).collect(Collectors.toList());
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(HashSet::new);
        for (Arbitrary childArbitrary : childrenArbitraries) {
            builderCombinator = builderCombinator.use(childArbitrary).in((set, element) -> {
                set.add(element);
                return set;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(set -> {
            context.evictUnique(context.getPathProperty());
            return set;
        }));
    }
}

