/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class StreamIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final List<Matcher> MATCHERS = Arrays.asList(new AssignableTypeMatcher(Stream.class), new AssignableTypeMatcher(IntStream.class), new AssignableTypeMatcher(LongStream.class), new AssignableTypeMatcher(DoubleStream.class));

    @Override
    public boolean match(Property property) {
        return MATCHERS.stream().anyMatch(it -> it.match(property));
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<Arbitrary<?>> childrenArbitraries = context.getChildrenArbitraryContexts().getArbitraries();
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(Stream::builder);
        for (Arbitrary<?> childArbitrary : childrenArbitraries) {
            builderCombinator = builderCombinator.use(childArbitrary).in(Stream.Builder::add);
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(Stream.Builder::build));
    }
}

