/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.lazy;

import com.navercorp.fixturemonkey.api.lazy.UnSafeLazyArbitraryImpl;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public interface LazyArbitrary<T> {
    public T getValue();

    public boolean isInitialized();

    public void clear();

    public static <T> LazyArbitrary<T> lazy(Supplier<T> initializer, boolean fixed, LazyThreadSafetyMode mode) {
        if (mode == LazyThreadSafetyMode.NONE) {
            return new UnSafeLazyArbitraryImpl<T>(initializer, fixed);
        }
        throw new IllegalArgumentException("Unsupported lazy thread safety mode: " + (Object)((Object)mode));
    }

    public static <T> LazyArbitrary<T> lazy(Supplier<T> initializer, LazyThreadSafetyMode mode) {
        return LazyArbitrary.lazy(initializer, false, mode);
    }

    public static <T> LazyArbitrary<T> lazy(Supplier<T> initializer) {
        return LazyArbitrary.lazy(initializer, LazyThreadSafetyMode.NONE);
    }

    public static <T> LazyArbitrary<T> lazy(Supplier<T> initializer, boolean fixed) {
        return LazyArbitrary.lazy(initializer, fixed, LazyThreadSafetyMode.NONE);
    }

    public static enum LazyThreadSafetyMode {
        NONE;

    }
}

