/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.lazy;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class UnSafeLazyArbitraryImpl<T>
implements LazyArbitrary<T> {
    private static final Object UNINITIALIZED_VALUE = new Object();
    private final Supplier<T> initializer;
    private final boolean fixed;
    private Object value = UNINITIALIZED_VALUE;

    UnSafeLazyArbitraryImpl(T value) {
        this.value = value;
        this.initializer = () -> value;
        this.fixed = true;
    }

    UnSafeLazyArbitraryImpl(Supplier<T> initializer, boolean fixed) {
        this.initializer = initializer;
        this.fixed = fixed;
    }

    UnSafeLazyArbitraryImpl(Supplier<T> initializer) {
        this(initializer, false);
    }

    @Override
    public T getValue() {
        if (this.value == UNINITIALIZED_VALUE) {
            this.value = this.initializer.get();
        }
        return (T)this.value;
    }

    @Override
    public boolean isInitialized() {
        return this.value != UNINITIALIZED_VALUE;
    }

    @Override
    public void clear() {
        if (!this.fixed) {
            this.value = UNINITIALIZED_VALUE;
        }
    }
}

