/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.EXPERIMENTAL)
public final class FactoryMethodProperty
implements Property {
    private final AnnotatedType annotatedType;
    private final Method factoryMethod;
    private final String parameterName;
    @Nullable
    private final Property fieldProperty;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public FactoryMethodProperty(AnnotatedType annotatedType, Method factoryMethod, String parameterName, @Nullable Property fieldProperty) {
        this.annotatedType = annotatedType;
        this.factoryMethod = factoryMethod;
        this.parameterName = parameterName;
        this.fieldProperty = fieldProperty;
        this.annotations = Arrays.asList(annotatedType.getAnnotations());
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    @Nullable
    public Property getFieldProperty() {
        return this.fieldProperty;
    }

    @Override
    public String getName() {
        return this.parameterName;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FactoryMethodProperty that = (FactoryMethodProperty)obj;
        return this.annotatedType.equals(that.annotatedType) && this.factoryMethod.equals(that.factoryMethod) && this.parameterName.equals(that.parameterName) && Objects.equals(this.fieldProperty, that.fieldProperty) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedType, this.factoryMethod, this.parameterName, this.fieldProperty, this.annotations);
    }

    @Override
    @Nullable
    public Object getValue(Object obj) {
        if (this.fieldProperty != null) {
            return this.fieldProperty.getValue(obj);
        }
        return null;
    }

    public String toString() {
        return "FactoryMethodProperty{annotatedType=" + this.annotatedType + ", factoryMethod=" + this.factoryMethod + ", parameterName='" + this.parameterName + '\'' + ", fieldProperty=" + this.fieldProperty + '}';
    }
}

