/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.collection.LruCache;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.ConstructorProperty;
import com.navercorp.fixturemonkey.api.property.FactoryMethodProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyDescriptorProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.ConstructorProperties;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class PropertyCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyCache.class);
    private static final Map<Class<?>, Map<String, PropertyDescriptor>> PROPERTY_DESCRIPTORS = new LruCache(2000);
    private static final Map<Class<?>, Map<String, Field>> FIELDS = new LruCache(2000);
    private static final Map<Class<?>, Map.Entry<Constructor<?>, String[]>> PARAMETER_NAMES_BY_PRIMARY_CONSTRUCTOR = new LruCache(2000);
    private static final Map<Class<?>, Map<Method, Parameter[]>> PARAMETER_BY_FACTORY_METHOD = new LruCache(2000);

    public static List<Property> getProperties(AnnotatedType annotatedType) {
        HashMap<String, List> propertiesMap = new HashMap<String, List>();
        Class<?> actualType = Types.getActualType(annotatedType.getType());
        Map<String, Property> constructorProperties = PropertyCache.getConstructorProperties(actualType);
        for (Map.Entry<String, Property> entry : constructorProperties.entrySet()) {
            List list = propertiesMap.computeIfAbsent(entry.getKey(), name -> new ArrayList());
            list.add(entry.getValue());
        }
        Map<String, Field> fieldMap = PropertyCache.getFields(actualType);
        for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
            List list = propertiesMap.computeIfAbsent(entry.getKey(), name -> new ArrayList());
            list.add(new FieldProperty(Types.resolveWithTypeReferenceGenerics(annotatedType, entry.getValue()), entry.getValue()));
        }
        Map<String, PropertyDescriptor> map = PropertyCache.getPropertyDescriptors(actualType);
        for (Map.Entry<String, PropertyDescriptor> entry : map.entrySet()) {
            List properties = propertiesMap.computeIfAbsent(entry.getValue().getName(), name -> new ArrayList());
            properties.add(new PropertyDescriptorProperty(Types.resolveWithTypeReferenceGenerics(annotatedType, entry.getValue()), entry.getValue()));
        }
        ArrayList arrayList = new ArrayList();
        for (List properties : propertiesMap.values()) {
            if (properties.size() == 1) {
                arrayList.add(properties.get(0));
                continue;
            }
            arrayList.add(new CompositeProperty((Property)properties.get(0), (Property)properties.get(1)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Optional<Property> getProperty(AnnotatedType annotatedType, String name) {
        return PropertyCache.getProperties(annotatedType).stream().filter(it -> name.equals(it.getName())).findFirst();
    }

    public static Map<String, Field> getFields(Class<?> clazz) {
        return FIELDS.computeIfAbsent(clazz, type -> {
            ConcurrentHashMap<String, Field> result = new ConcurrentHashMap<String, Field>();
            List fields = ReflectionUtils.findFields((Class)clazz, field -> !Modifier.isStatic(field.getModifiers()), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
            for (Field field2 : fields) {
                field2.setAccessible(true);
                result.put(field2.getName(), field2);
            }
            return result;
        });
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        return PROPERTY_DESCRIPTORS.computeIfAbsent(clazz, type -> {
            ConcurrentHashMap<String, PropertyDescriptor> result = new ConcurrentHashMap<String, PropertyDescriptor>();
            try {
                PropertyDescriptor[] descriptors;
                for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    if (descriptor.getName().equals("class")) continue;
                    result.put(descriptor.getName(), descriptor);
                }
            }
            catch (IntrospectionException ex) {
                LOGGER.warn("Introspect bean property is failed. type: " + clazz, (Throwable)ex);
            }
            return result;
        });
    }

    public static List<Property> getFactoryProperties(AnnotatedType annotatedType) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Class<?> actualType = Types.getActualType(annotatedType);
        Map<String, Field> fieldsByName = PropertyCache.getFields(actualType);
        Map<Method, Parameter[]> parametersByFactoryMethods = PropertyCache.getParametersByFactoryMethods(actualType);
        Iterator<Map.Entry<Method, Parameter[]>> iterator = parametersByFactoryMethods.entrySet().iterator();
        if (iterator.hasNext()) {
            Parameter[] parameters;
            Map.Entry<Method, Parameter[]> parametersByFactoryMethod = iterator.next();
            Method method = parametersByFactoryMethod.getKey();
            for (Parameter parameter : parameters = parametersByFactoryMethod.getValue()) {
                Field field = fieldsByName.get(parameter.getName());
                FieldProperty fieldProperty = field != null ? new FieldProperty(field) : null;
                properties.add(new FactoryMethodProperty(parameter.getAnnotatedType(), method, parameter.getName(), fieldProperty));
            }
            return properties;
        }
        return properties;
    }

    public static Map<Method, Parameter[]> getParametersByFactoryMethods(Class<?> clazz) {
        return PARAMETER_BY_FACTORY_METHOD.computeIfAbsent(clazz, type -> {
            ConcurrentHashMap<Method, Parameter[]> result = new ConcurrentHashMap<Method, Parameter[]>();
            List factoryMethods = Arrays.stream(type.getDeclaredMethods()).filter(it -> Modifier.isStatic(it.getModifiers()) && it.getReturnType().equals(type)).collect(Collectors.toList());
            for (Method factoryMethod : factoryMethods) {
                result.put(factoryMethod, factoryMethod.getParameters());
            }
            return result;
        });
    }

    public static Map<String, Property> getConstructorProperties(Class<?> clazz) {
        HashMap<String, ConstructorProperty> constructorPropertiesByName = new HashMap<String, ConstructorProperty>();
        Map.Entry<Constructor<?>, String[]> parameterNamesByConstructor = PropertyCache.getParameterNamesByConstructor(clazz);
        if (parameterNamesByConstructor == null) {
            return Collections.emptyMap();
        }
        Constructor<?> primaryConstructor = parameterNamesByConstructor.getKey();
        String[] parameterNames = parameterNamesByConstructor.getValue();
        AnnotatedType[] annotatedParameterTypes = primaryConstructor.getAnnotatedParameterTypes();
        Map<String, Field> fieldsByName = PropertyCache.getFields(clazz);
        int parameterSize = parameterNames.length;
        for (int i = 0; i < parameterSize; ++i) {
            AnnotatedType annotatedParameterType = annotatedParameterTypes[i];
            String parameterName = parameterNames[i];
            Field field = fieldsByName.get(parameterName);
            FieldProperty fieldProperty = field != null ? new FieldProperty(field) : null;
            constructorPropertiesByName.put(parameterName, new ConstructorProperty(annotatedParameterType, primaryConstructor, parameterName, fieldProperty));
        }
        return Collections.unmodifiableMap(constructorPropertiesByName);
    }

    @Nullable
    public static Map.Entry<Constructor<?>, String[]> getParameterNamesByConstructor(Class<?> clazz) {
        return PARAMETER_NAMES_BY_PRIMARY_CONSTRUCTOR.computeIfAbsent(clazz, type -> {
            AnnotatedType[] annotatedParameterTypes;
            Constructor<?>[] constructors;
            ArrayList possibilities = new ArrayList();
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                Parameter[] parameters = constructor.getParameters();
                boolean namePresent = Arrays.stream(parameters).anyMatch(Parameter::isNamePresent);
                if (namePresent) {
                    possibilities.add(constructor);
                    continue;
                }
                ConstructorProperties constructorPropertiesAnnotation = constructor.getAnnotation(ConstructorProperties.class);
                if (constructorPropertiesAnnotation == null) continue;
                possibilities.add(constructor);
            }
            boolean constructorPropertiesPresent = possibilities.stream().anyMatch(it -> it.getAnnotation(ConstructorProperties.class) != null);
            Constructor primaryConstructor = constructorPropertiesPresent ? possibilities.stream().filter(it -> it.getAnnotation(ConstructorProperties.class) != null).findFirst().orElseThrow(() -> new IllegalArgumentException("Constructor should have @ConstructorProperties" + clazz.getSimpleName())) : (Constructor)possibilities.stream().findFirst().orElse(null);
            if (primaryConstructor == null) {
                return null;
            }
            String[] parameterNames = PropertyCache.getParameterNames(primaryConstructor);
            if (parameterNames.length != (annotatedParameterTypes = primaryConstructor.getAnnotatedParameterTypes()).length) {
                throw new IllegalArgumentException("@ConstructorProperties values size should same as constructor parameter size");
            }
            return new AbstractMap.SimpleEntry<Constructor, String[]>(primaryConstructor, parameterNames);
        });
    }

    public static void clearCache() {
        PROPERTY_DESCRIPTORS.clear();
        FIELDS.clear();
    }

    private static String[] getParameterNames(Constructor<?> constructor) {
        Parameter[] parameters = constructor.getParameters();
        boolean namePresent = Arrays.stream(parameters).anyMatch(Parameter::isNamePresent);
        if (namePresent) {
            return (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
        }
        ConstructorProperties constructorPropertiesAnnotation = constructor.getAnnotation(ConstructorProperties.class);
        return constructorPropertiesAnnotation.value();
    }
}

