/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.random;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.jqwik.api.JqwikException;
import net.jqwik.engine.SourceOfRandomness;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
public class Randoms {
    private static final boolean USE_JQWIK_ENGINE;
    private static final Supplier<Random> RNG;
    private static final ThreadLocal<Random> CURRENT;

    private Randoms() {
    }

    public static String createRandomSeed() {
        return USE_JQWIK_ENGINE ? SourceOfRandomness.createRandomSeed() : Long.toString(RNG.get().nextLong());
    }

    public static Random create(String seed) {
        if (USE_JQWIK_ENGINE) {
            return SourceOfRandomness.create((String)seed);
        }
        try {
            Random random = Randoms.newRandom(Long.parseLong(seed));
            CURRENT.set(random);
            return random;
        }
        catch (NumberFormatException nfe) {
            throw new JqwikException(String.format("[%s] is not a valid random seed.", seed));
        }
    }

    public static Random newRandom() {
        return USE_JQWIK_ENGINE ? SourceOfRandomness.newRandom() : new XorShiftRandom();
    }

    public static Random newRandom(long seed) {
        return USE_JQWIK_ENGINE ? SourceOfRandomness.newRandom((long)seed) : new XorShiftRandom(seed);
    }

    public static Random current() {
        return USE_JQWIK_ENGINE ? SourceOfRandomness.current() : CURRENT.get();
    }

    public static int nextInt(int bound) {
        return Randoms.current().nextInt(bound);
    }

    static {
        boolean useJqwikEngine;
        RNG = ThreadLocalRandom::current;
        CURRENT = ThreadLocal.withInitial(Randoms::newRandom);
        try {
            Class.forName("net.jqwik.engine.SourceOfRandomness");
            useJqwikEngine = true;
        }
        catch (ClassNotFoundException e) {
            useJqwikEngine = false;
        }
        USE_JQWIK_ENGINE = useJqwikEngine;
    }

    private static class XorShiftRandom
    extends Random {
        private long seed;

        private XorShiftRandom() {
            this(System.nanoTime());
        }

        private XorShiftRandom(long seed) {
            if (seed == 0L) {
                throw new IllegalArgumentException("0L is not an allowed seed value");
            }
            this.seed = seed;
        }

        @Override
        protected int next(int nbits) {
            long value = this.nextLong();
            return (int)(value &= (1L << nbits) - 1L);
        }

        @Override
        public long nextLong() {
            long value = this.seed;
            value ^= value << 21;
            value ^= value >>> 35;
            value ^= value << 4;
            this.seed = value;
            return value;
        }
    }
}

