/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public abstract class TypeReference<T> {
    private final AnnotatedType annotatedType;

    protected TypeReference() {
        AnnotatedType annotatedType = this.getClass().getAnnotatedSuperclass();
        this.annotatedType = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[0];
    }

    protected TypeReference(Class<T> type) {
        this.annotatedType = Types.generateAnnotatedTypeWithoutAnnotation(type);
    }

    public Type getType() {
        return this.annotatedType.getType();
    }

    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public boolean isGenericType() {
        return !Types.getGenericsTypes(this.annotatedType).isEmpty();
    }
}

