/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.collection.LruCache;
import com.navercorp.fixturemonkey.api.context.MonkeyContextBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import java.util.Set;
import java.util.TreeMap;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MonkeyContext {
    private final LruCache<Property, Arbitrary<?>> arbitrariesByProperty;
    private final LruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty;

    public MonkeyContext(LruCache<Property, Arbitrary<?>> arbitrariesByProperty, LruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty) {
        this.arbitrariesByProperty = arbitrariesByProperty;
        this.generatorContextByRootProperty = generatorContextByRootProperty;
    }

    public static MonkeyContextBuilder builder() {
        return new MonkeyContextBuilder();
    }

    public Arbitrary<?> getCachedArbitrary(Property property) {
        return (Arbitrary)this.arbitrariesByProperty.get(property);
    }

    public void putCachedArbitrary(Property property, Arbitrary<?> arbitrary) {
        this.arbitrariesByProperty.put(property, arbitrary);
    }

    public MonkeyGeneratorContext retrieveGeneratorContext(RootProperty rootProperty) {
        return this.generatorContextByRootProperty.computeIfAbsent(rootProperty, property -> new MonkeyGeneratorContext(new TreeMap<ArbitraryGeneratorContext.PropertyPath, Set<Object>>()));
    }
}

