/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ChildArbitraryContext;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryGeneratorContext {
    private final Property resolvedProperty;
    private final ArbitraryProperty property;
    private final List<ArbitraryProperty> children;
    @Nullable
    private final ArbitraryGeneratorContext ownerContext;
    private final BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, Arbitrary<Object>> resolveArbitrary;
    private final List<MatcherOperator<? extends FixtureCustomizer>> fixtureCustomizers;
    private final MonkeyGeneratorContext monkeyGeneratorContext;
    private final LazyArbitrary<PropertyPath> pathProperty = LazyArbitrary.lazy(this::initPathProperty);
    private final LazyArbitrary<ChildArbitraryContext> childArbitraryContext = LazyArbitrary.lazy(this::initChildArbitraryContext);

    public ArbitraryGeneratorContext(Property resolvedProperty, ArbitraryProperty property, List<ArbitraryProperty> children, @Nullable ArbitraryGeneratorContext ownerContext, BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, Arbitrary<Object>> resolveArbitrary, List<MatcherOperator<? extends FixtureCustomizer>> fixtureCustomizers, MonkeyGeneratorContext monkeyGeneratorContext) {
        this.resolvedProperty = resolvedProperty;
        this.property = property;
        this.children = new ArrayList<ArbitraryProperty>(children);
        this.ownerContext = ownerContext;
        this.resolveArbitrary = resolveArbitrary;
        this.fixtureCustomizers = fixtureCustomizers;
        this.monkeyGeneratorContext = monkeyGeneratorContext;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.property;
    }

    public Property getResolvedProperty() {
        return this.resolvedProperty;
    }

    public AnnotatedType getResolvedAnnotatedType() {
        return this.getResolvedProperty().getAnnotatedType();
    }

    public Type getResolvedType() {
        return this.getResolvedProperty().getType();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return this.getResolvedProperty().getAnnotation(annotationClass);
    }

    public List<ArbitraryProperty> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Map<String, LazyArbitrary<Arbitrary<?>>> getArbitrariesByResolvedName() {
        return this.childArbitraryContext.getValue().getArbitrariesByResolvedName();
    }

    public Map<String, LazyArbitrary<Arbitrary<?>>> getArbitrariesByPropertyName() {
        return this.childArbitraryContext.getValue().getArbitrariesByPropertyName();
    }

    public List<Arbitrary<?>> getArbitraries() {
        return this.childArbitraryContext.getValue().getArbitraries();
    }

    @Nullable
    public ArbitraryGeneratorContext getOwnerContext() {
        return this.ownerContext;
    }

    public boolean isRootContext() {
        return this.property.getObjectProperty().isRoot();
    }

    public List<MatcherOperator<? extends FixtureCustomizer>> getFixtureCustomizers() {
        return this.fixtureCustomizers;
    }

    public synchronized boolean isUniqueAndCheck(PropertyPath property, Object value) {
        return this.monkeyGeneratorContext.isUniqueAndCheck(property, value);
    }

    public void evictUnique(PropertyPath propertyPath) {
        this.monkeyGeneratorContext.evictUnique(propertyPath);
    }

    public PropertyPath getPathProperty() {
        return this.pathProperty.getValue();
    }

    private PropertyPath initPathProperty() {
        if (this.ownerContext == null) {
            return new PropertyPath(this.property.getObjectProperty().getProperty(), null, 1);
        }
        PropertyPath parentPropertyPath = this.ownerContext.getPathProperty();
        return new PropertyPath(this.property.getObjectProperty().getProperty(), parentPropertyPath, parentPropertyPath.getDepth() + 1);
    }

    private ChildArbitraryContext initChildArbitraryContext() {
        LinkedHashMap childrenValues = new LinkedHashMap();
        for (ArbitraryProperty child : this.getChildren()) {
            childrenValues.put(child, LazyArbitrary.lazy(() -> this.resolveArbitrary.apply(this, child)));
        }
        ChildArbitraryContext childArbitraryContext = new ChildArbitraryContext(this.property.getObjectProperty().getProperty(), childrenValues);
        this.fixtureCustomizers.stream().filter(it -> it.match(this.property.getObjectProperty().getProperty())).map(MatcherOperator::getOperator).findFirst().ifPresent(customizer -> customizer.customizeProperties(childArbitraryContext));
        return childArbitraryContext;
    }

    public static class PropertyPath
    implements Comparable<PropertyPath> {
        private final Property property;
        @Nullable
        private final PropertyPath parentPropertyPath;
        private final int depth;

        public PropertyPath(Property property, @Nullable PropertyPath parentPropertyPath, int depth) {
            this.property = property;
            this.parentPropertyPath = parentPropertyPath;
            this.depth = depth;
        }

        public Property getProperty() {
            return this.property;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyPath that = (PropertyPath)obj;
            return this.depth == that.depth && this.property.equals(that.property) && Objects.equals(this.parentPropertyPath, that.parentPropertyPath);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.parentPropertyPath, this.depth);
        }

        @Override
        public int compareTo(PropertyPath obj) {
            return Integer.compare(obj.depth, this.depth);
        }
    }
}

