/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectPropertyGeneratorContext {
    private final Property property;
    @Nullable
    private final Integer elementIndex;
    @Nullable
    private final ArbitraryProperty ownerProperty;
    private final boolean container;
    private final GenerateOptions generateOptions;

    public ObjectPropertyGeneratorContext(Property property, @Nullable Integer elementIndex, @Nullable ArbitraryProperty ownerProperty, boolean container, GenerateOptions generateOptions) {
        this.property = property;
        this.elementIndex = elementIndex;
        this.ownerProperty = ownerProperty;
        this.container = container;
        this.generateOptions = generateOptions;
    }

    public Property getProperty() {
        return this.property;
    }

    @Nullable
    public Integer getElementIndex() {
        return this.elementIndex;
    }

    @Nullable
    public ArbitraryProperty getOwnerProperty() {
        return this.ownerProperty;
    }

    public boolean isContainer() {
        return this.container;
    }

    public GenerateOptions getGenerateOptions() {
        return this.generateOptions;
    }

    public PropertyNameResolver getPropertyNameResolver() {
        return this.generateOptions.getPropertyNameResolver(this.property);
    }

    public boolean isRootContext() {
        return this.property instanceof RootProperty;
    }
}

