/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ReflectionUtils;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public final class ConstructorPropertiesArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final ConstructorPropertiesArbitraryIntrospector INSTANCE = new ConstructorPropertiesArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        Map<String, LazyArbitrary<Arbitrary<?>>> childrenArbitraries = context.getArbitrariesByResolvedName();
        Map.Entry<Constructor<?>, String[]> parameterNamesByConstructor = PropertyCache.getParameterNamesByConstructor(type);
        if (parameterNamesByConstructor == null) {
            throw new IllegalArgumentException("Primary Constructor does not exist. type " + type.getSimpleName());
        }
        Constructor<?> primaryConstructor = parameterNamesByConstructor.getKey();
        String[] parameterNames = parameterNamesByConstructor.getValue();
        int parameterSize = parameterNames.length;
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> new ArrayList(parameterSize));
        for (String parameterName : parameterNames) {
            Arbitrary arbitrary = childrenArbitraries.getOrDefault(parameterName, LazyArbitrary.lazy(() -> Arbitraries.just(null))).getValue();
            builderCombinator = builderCombinator.use(arbitrary).in((list, value) -> {
                list.add(value);
                return list;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(list -> ReflectionUtils.newInstance((Constructor)primaryConstructor, (Object[])list.toArray())));
    }
}

