/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class FieldReflectionArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final FieldReflectionArbitraryIntrospector INSTANCE = new FieldReflectionArbitraryIntrospector();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<ArbitraryProperty> childrenProperties = context.getChildren();
        Map<String, LazyArbitrary<Arbitrary<?>>> childrenArbitraries = context.getArbitrariesByResolvedName();
        Map<String, Field> fields = PropertyCache.getFields(type);
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> ReflectionUtils.newInstance((Class)type, (Object[])new Object[0]));
        for (ArbitraryProperty arbitraryProperty : childrenProperties) {
            String originPropertyName = arbitraryProperty.getObjectProperty().getProperty().getName();
            Field field = fields.get(originPropertyName);
            if (field == null || Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            String resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName();
            Arbitrary arbitrary = childrenArbitraries.getOrDefault(resolvePropertyName, LazyArbitrary.lazy(() -> Arbitraries.just(null))).getValue();
            builderCombinator = builderCombinator.use(arbitrary).in((object, value) -> {
                try {
                    if (value != null) {
                        field.set(object, value);
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.warn("set field by reflection is failed. field: {} value: {}", new Object[]{resolvePropertyName, value, e});
                }
                return object;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build());
    }
}

