/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.CombinedShrinkable;
import org.apiguardian.api.API;

@API(since="0.4.6", status=API.Status.EXPERIMENTAL)
final class MonkeyCombineArbitrary
implements Arbitrary<Object> {
    private final Function<List<Object>, Object> combinator;
    private final Runnable combinationCallback;
    private final List<Arbitrary<Object>> arbitraries;

    public MonkeyCombineArbitrary(Function<List<Object>, Object> combinator, Runnable combinationCallback, List arbitraries) {
        this.combinator = combinator;
        this.combinationCallback = combinationCallback;
        this.arbitraries = arbitraries;
    }

    public RandomGenerator<Object> generator(int genSize) {
        return this.combineGenerator(genSize, this.combinator, this.arbitraries);
    }

    public RandomGenerator<Object> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.combineGeneratorWithEmbeddedEdgeCases(genSize, this.combinator, this.arbitraries);
    }

    public Optional<ExhaustiveGenerator<Object>> exhaustive(long maxNumberOfSamples) {
        return this.combineExhaustive(this.arbitraries, this.combinator, maxNumberOfSamples);
    }

    public boolean isGeneratorMemoizable() {
        return this.isCombinedGeneratorMemoizable(this.arbitraries);
    }

    public EdgeCases<Object> edgeCases(int maxEdgeCases) {
        return this.combineEdgeCases(this.arbitraries, this.combinator, maxEdgeCases);
    }

    private boolean isCombinedGeneratorMemoizable(List<Arbitrary<Object>> arbitraries) {
        return arbitraries.stream().allMatch(Arbitrary::isGeneratorMemoizable);
    }

    private RandomGenerator<Object> combineGenerator(int genSize, Function<List<Object>, Object> combineFunction, List<Arbitrary<Object>> arbitraries) {
        List generators = arbitraries.stream().map(a -> a.generator(genSize)).collect(Collectors.toList());
        return random -> {
            List<Shrinkable<Object>> shrinkables = this.generateShrinkables(generators, random);
            return this.combineShrinkables(shrinkables, combineFunction);
        };
    }

    private RandomGenerator<Object> combineGeneratorWithEmbeddedEdgeCases(int genSize, Function<List<Object>, Object> combineFunction, List<Arbitrary<Object>> arbitraries) {
        List generators = arbitraries.stream().map(a -> a.generatorWithEmbeddedEdgeCases(genSize)).collect(Collectors.toList());
        return random -> {
            List<Shrinkable<Object>> shrinkables = this.generateShrinkables(generators, random);
            return this.combineShrinkables(shrinkables, combineFunction);
        };
    }

    private List<Shrinkable<Object>> generateShrinkables(List<RandomGenerator<Object>> generators, Random random) {
        ArrayList<Shrinkable<Object>> list = new ArrayList<Shrinkable<Object>>();
        for (RandomGenerator<Object> generator : generators) {
            list.add((Shrinkable<Object>)generator.next(random));
        }
        this.combinationCallback.run();
        return list;
    }

    private Shrinkable<Object> combineShrinkables(List<Shrinkable<Object>> shrinkables, Function<List<Object>, Object> combineFunction) {
        return new CombinedShrinkable(shrinkables, combineFunction);
    }

    private Optional<ExhaustiveGenerator<Object>> combineExhaustive(List<Arbitrary<Object>> arbitraries, Function<List<Object>, Object> combineFunction, long maxNumberOfSamples) {
        return ExhaustiveGenerators.combine(arbitraries, combineFunction, (long)maxNumberOfSamples);
    }

    private EdgeCases<Object> combineEdgeCases(List<Arbitrary<Object>> arbitraries, Function<List<Object>, Object> combineFunction, int maxEdgeCases) {
        return EdgeCasesSupport.combine(arbitraries, combineFunction, (int)maxEdgeCases);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MonkeyCombineArbitrary that = (MonkeyCombineArbitrary)obj;
        if (!this.arbitraries.equals(that.arbitraries)) {
            return false;
        }
        return LambdaSupport.areEqual(this.combinator, that.combinator);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.arbitraries);
    }
}

