/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class OptionalIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        Class<?> type = Types.getActualType(property.getType());
        return type == Optional.class || type == OptionalInt.class || type == OptionalLong.class || type == OptionalDouble.class;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        List<ArbitraryProperty> children = context.getChildren();
        if (containerInfo == null || children.size() != 1) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        ArbitraryProperty valueProperty = children.get(0);
        double presenceProbability = 1.0 - valueProperty.getObjectProperty().getNullInject();
        if (containerInfo.getElementMinSize() > 0) {
            presenceProbability = 1.0;
        } else if (containerInfo.getElementMaxSize() == 0) {
            presenceProbability = 0.0;
        }
        Class<?> type = Types.getActualType(property.getObjectProperty().getProperty().getType());
        List<Arbitrary<?>> childArbitraries = context.getArbitraries();
        Arbitrary elementArbitrary = childArbitraries.get(0).optional(presenceProbability).map(it -> {
            if (type == OptionalInt.class) {
                return it.map(o -> OptionalInt.of((Integer)o)).orElseGet(OptionalInt::empty);
            }
            if (type == OptionalLong.class) {
                return it.map(o -> OptionalLong.of((Long)o)).orElseGet(OptionalLong::empty);
            }
            if (type == OptionalDouble.class) {
                return it.map(o -> OptionalDouble.of((Double)o)).orElseGet(OptionalDouble::empty);
            }
            return it;
        });
        return new ArbitraryIntrospectorResult(elementArbitrary);
    }
}

