/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class QueueIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Queue.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<Arbitrary<?>> childrenArbitraries = context.getArbitraries();
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(LinkedList::new);
        for (Arbitrary<?> childArbitrary : childrenArbitraries) {
            builderCombinator = builderCombinator.use(childArbitrary).in((list, element) -> {
                list.add(element);
                return list;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build());
    }
}

