/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.option;

import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultNullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.JavaDefaultArbitraryGeneratorBuilder;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.PropertyGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.JavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.introspector.JavaTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class GenerateOptionsBuilder {
    private List<MatcherOperator<PropertyGenerator>> propertyGenerators = new ArrayList<MatcherOperator<PropertyGenerator>>();
    private PropertyGenerator defaultPropertyGenerator = new DefaultPropertyGenerator();
    private List<MatcherOperator<ObjectPropertyGenerator>> arbitraryObjectPropertyGenerators = new ArrayList<MatcherOperator<ObjectPropertyGenerator>>(GenerateOptions.DEFAULT_OBJECT_PROPERTY_GENERATORS);
    private List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators = new ArrayList<MatcherOperator<ContainerPropertyGenerator>>(GenerateOptions.DEFAULT_CONTAINER_PROPERTY_GENERATORS);
    private ObjectPropertyGenerator defaultObjectPropertyGenerator;
    private List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers = new ArrayList<MatcherOperator<PropertyNameResolver>>();
    private PropertyNameResolver defaultPropertyNameResolver;
    private List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators = new ArrayList<MatcherOperator<NullInjectGenerator>>();
    private NullInjectGenerator defaultNullInjectGenerator;
    private List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators = new ArrayList<MatcherOperator<ArbitraryContainerInfoGenerator>>();
    private ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator;
    private List<MatcherOperator<ArbitraryGenerator>> arbitraryGenerators = new ArrayList<MatcherOperator<ArbitraryGenerator>>();
    private ArbitraryGenerator defaultArbitraryGenerator;
    private List<MatcherOperator<FixtureCustomizer>> arbitraryCustomizers = new ArrayList<MatcherOperator<FixtureCustomizer>>();
    private final JavaDefaultArbitraryGeneratorBuilder javaDefaultArbitraryGeneratorBuilder = DefaultArbitraryGenerator.javaBuilder();
    private boolean defaultNotNull = false;
    private boolean nullableContainer = false;
    private boolean nullableElement = false;
    private UnaryOperator<NullInjectGenerator> defaultNullInjectGeneratorOperator = it -> it;
    private ArbitraryValidator defaultArbitraryValidator = obj -> {};

    GenerateOptionsBuilder() {
    }

    public GenerateOptionsBuilder propertyGenerators(List<MatcherOperator<PropertyGenerator>> propertyGenerators) {
        this.propertyGenerators = propertyGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstPropertyGenerator(MatcherOperator<PropertyGenerator> propertyGenerator) {
        List<MatcherOperator<PropertyGenerator>> result = GenerateOptionsBuilder.insertFirst(this.propertyGenerators, propertyGenerator);
        return this.propertyGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstPropertyGenerator(Matcher matcher, PropertyGenerator propertyGenerator) {
        return this.insertFirstPropertyGenerator(new MatcherOperator<PropertyGenerator>(matcher, propertyGenerator));
    }

    public GenerateOptionsBuilder insertFirstPropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        return this.insertFirstPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, propertyGenerator));
    }

    public GenerateOptionsBuilder defaultPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.defaultPropertyGenerator = propertyGenerator;
        return this;
    }

    public GenerateOptionsBuilder arbitraryObjectPropertyGenerators(List<MatcherOperator<ObjectPropertyGenerator>> arbitraryObjectPropertyGenerators) {
        this.arbitraryObjectPropertyGenerators = arbitraryObjectPropertyGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(MatcherOperator<ObjectPropertyGenerator> arbitraryObjectPropertyGenerator) {
        List<MatcherOperator<ObjectPropertyGenerator>> result = GenerateOptionsBuilder.insertFirst(this.arbitraryObjectPropertyGenerators, arbitraryObjectPropertyGenerator);
        return this.arbitraryObjectPropertyGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(Matcher matcher, ObjectPropertyGenerator objectPropertyGenerator) {
        return this.insertFirstArbitraryObjectPropertyGenerator(new MatcherOperator<ObjectPropertyGenerator>(matcher, objectPropertyGenerator));
    }

    public GenerateOptionsBuilder insertFirstArbitraryObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        return this.insertFirstArbitraryObjectPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, objectPropertyGenerator));
    }

    public GenerateOptionsBuilder arbitraryContainerPropertyGenerators(List<MatcherOperator<ContainerPropertyGenerator>> arbitraryContainerPropertyGenerators) {
        this.containerPropertyGenerators = arbitraryContainerPropertyGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(MatcherOperator<ContainerPropertyGenerator> arbitraryContainerPropertyGenerator) {
        List<MatcherOperator<ContainerPropertyGenerator>> result = GenerateOptionsBuilder.insertFirst(this.containerPropertyGenerators, arbitraryContainerPropertyGenerator);
        return this.arbitraryContainerPropertyGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(Matcher matcher, ContainerPropertyGenerator containerPropertyGenerator) {
        return this.insertFirstArbitraryContainerPropertyGenerator(new MatcherOperator<ContainerPropertyGenerator>(matcher, containerPropertyGenerator));
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        return this.insertFirstArbitraryContainerPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, containerPropertyGenerator));
    }

    public GenerateOptionsBuilder defaultObjectPropertyGenerator(ObjectPropertyGenerator defaultObjectPropertyGenerator) {
        this.defaultObjectPropertyGenerator = defaultObjectPropertyGenerator;
        return this;
    }

    public GenerateOptionsBuilder propertyNameResolvers(List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers) {
        this.propertyNameResolvers = propertyNameResolvers;
        return this;
    }

    public GenerateOptionsBuilder insertFirstPropertyNameResolver(MatcherOperator<PropertyNameResolver> propertyNameResolver) {
        List<MatcherOperator<PropertyNameResolver>> result = GenerateOptionsBuilder.insertFirst(this.propertyNameResolvers, propertyNameResolver);
        return this.propertyNameResolvers(result);
    }

    public GenerateOptionsBuilder insertFirstPropertyNameResolver(Matcher matcher, PropertyNameResolver propertyNameResolver) {
        return this.insertFirstPropertyNameResolver(new MatcherOperator<PropertyNameResolver>(matcher, propertyNameResolver));
    }

    public GenerateOptionsBuilder insertFirstPropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        return this.insertFirstPropertyNameResolver(MatcherOperator.assignableTypeMatchOperator(type, propertyNameResolver));
    }

    public GenerateOptionsBuilder defaultPropertyNameResolver(PropertyNameResolver defaultPropertyNameResolver) {
        this.defaultPropertyNameResolver = defaultPropertyNameResolver;
        return this;
    }

    public GenerateOptionsBuilder nullInjectGenerators(List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators) {
        this.nullInjectGenerators = nullInjectGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstNullInjectGenerators(MatcherOperator<NullInjectGenerator> nullInjectGenerator) {
        List<MatcherOperator<NullInjectGenerator>> result = GenerateOptionsBuilder.insertFirst(this.nullInjectGenerators, nullInjectGenerator);
        return this.nullInjectGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstNullInjectGenerators(Matcher matcher, NullInjectGenerator nullInjectGenerator) {
        return this.insertFirstNullInjectGenerators(new MatcherOperator<NullInjectGenerator>(matcher, nullInjectGenerator));
    }

    public GenerateOptionsBuilder insertFirstNullInjectGenerators(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        return this.insertFirstNullInjectGenerators(MatcherOperator.assignableTypeMatchOperator(type, nullInjectGenerator));
    }

    public GenerateOptionsBuilder defaultNullInjectGenerator(NullInjectGenerator defaultNullInjectGenerator) {
        this.defaultNullInjectGenerator = defaultNullInjectGenerator;
        return this;
    }

    public GenerateOptionsBuilder defaultNullInjectGeneratorOperator(UnaryOperator<NullInjectGenerator> defaultNullInjectGeneratorOperator) {
        this.defaultNullInjectGeneratorOperator = defaultNullInjectGeneratorOperator;
        return this;
    }

    public GenerateOptionsBuilder arbitraryContainerInfoGenerators(List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators) {
        this.arbitraryContainerInfoGenerators = arbitraryContainerInfoGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerInfoGenerator(MatcherOperator<ArbitraryContainerInfoGenerator> arbitraryContainerInfoGenerator) {
        List<MatcherOperator<ArbitraryContainerInfoGenerator>> result = GenerateOptionsBuilder.insertFirst(this.arbitraryContainerInfoGenerators, arbitraryContainerInfoGenerator);
        return this.arbitraryContainerInfoGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerInfoGenerator(Matcher matcher, ArbitraryContainerInfoGenerator arbitraryContainerInfoGenerator) {
        return this.insertFirstArbitraryContainerInfoGenerator(new MatcherOperator<ArbitraryContainerInfoGenerator>(matcher, arbitraryContainerInfoGenerator));
    }

    public GenerateOptionsBuilder insertFirstArbitraryContainerInfoGenerator(Class<?> type, ArbitraryContainerInfoGenerator arbitraryContainerInfoGenerator) {
        return this.insertFirstArbitraryContainerInfoGenerator(MatcherOperator.assignableTypeMatchOperator(type, arbitraryContainerInfoGenerator));
    }

    public GenerateOptionsBuilder defaultArbitraryContainerInfoGenerator(ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator) {
        this.defaultArbitraryContainerInfoGenerator = defaultArbitraryContainerInfoGenerator;
        return this;
    }

    public GenerateOptionsBuilder arbitraryGenerators(List<MatcherOperator<ArbitraryGenerator>> arbitraryGenerators) {
        this.arbitraryGenerators = arbitraryGenerators;
        return this;
    }

    public GenerateOptionsBuilder insertFirstArbitraryGenerator(MatcherOperator<ArbitraryGenerator> arbitraryGenerator) {
        List<MatcherOperator<ArbitraryGenerator>> result = GenerateOptionsBuilder.insertFirst(this.arbitraryGenerators, arbitraryGenerator);
        return this.arbitraryGenerators(result);
    }

    public GenerateOptionsBuilder insertFirstArbitraryGenerator(Matcher matcher, ArbitraryGenerator arbitraryGenerator) {
        return this.insertFirstArbitraryGenerator(new MatcherOperator<ArbitraryGenerator>(matcher, arbitraryGenerator));
    }

    public GenerateOptionsBuilder insertFirstArbitraryGenerator(Class<?> type, ArbitraryGenerator arbitraryGenerator) {
        return this.insertFirstArbitraryGenerator(MatcherOperator.assignableTypeMatchOperator(type, arbitraryGenerator));
    }

    public GenerateOptionsBuilder insertFirstArbitraryIntrospector(MatcherOperator<ArbitraryIntrospector> arbitraryIntrospector) {
        return this.insertFirstArbitraryIntrospector(arbitraryIntrospector.getMatcher(), arbitraryIntrospector.getOperator());
    }

    public GenerateOptionsBuilder insertFirstArbitraryIntrospector(Matcher matcher, ArbitraryIntrospector arbitraryIntrospector) {
        return this.insertFirstArbitraryGenerator(matcher, (ArbitraryGenerator)new DefaultArbitraryGenerator(arbitraryIntrospector));
    }

    public GenerateOptionsBuilder insertFirstArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        return this.insertFirstArbitraryGenerator(MatcherOperator.assignableTypeMatchOperator(type, new DefaultArbitraryGenerator(arbitraryIntrospector)));
    }

    public GenerateOptionsBuilder defaultArbitraryGenerator(ArbitraryGenerator defaultArbitraryGenerator) {
        this.defaultArbitraryGenerator = defaultArbitraryGenerator;
        return this;
    }

    public GenerateOptionsBuilder priorityIntrospector(UnaryOperator<ArbitraryIntrospector> priorityIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.priorityIntrospector(priorityIntrospector);
        return this;
    }

    public GenerateOptionsBuilder containerIntrospector(UnaryOperator<ArbitraryIntrospector> containerIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.containerIntrospector(containerIntrospector);
        return this;
    }

    public GenerateOptionsBuilder objectIntrospector(UnaryOperator<ArbitraryIntrospector> objectIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.objectIntrospector(objectIntrospector);
        return this;
    }

    public GenerateOptionsBuilder fallbackIntrospector(UnaryOperator<ArbitraryIntrospector> fallbackIntrospector) {
        this.javaDefaultArbitraryGeneratorBuilder.fallbackIntrospector(fallbackIntrospector);
        return this;
    }

    public GenerateOptionsBuilder javaTypeArbitraryGenerator(JavaTypeArbitraryGenerator javaTypeArbitraryGenerator) {
        this.javaDefaultArbitraryGeneratorBuilder.javaTypeArbitraryGenerator(javaTypeArbitraryGenerator);
        return this;
    }

    public GenerateOptionsBuilder javaArbitraryResolver(JavaArbitraryResolver javaArbitraryResolver) {
        this.javaDefaultArbitraryGeneratorBuilder.javaArbitraryResolver(javaArbitraryResolver);
        return this;
    }

    public GenerateOptionsBuilder javaTimeTypeArbitraryGenerator(JavaTimeTypeArbitraryGenerator javaTimeTypeArbitraryGenerator) {
        this.javaDefaultArbitraryGeneratorBuilder.javaTimeTypeArbitraryGenerator(javaTimeTypeArbitraryGenerator);
        return this;
    }

    public GenerateOptionsBuilder javaTimeArbitraryResolver(JavaTimeArbitraryResolver javaTimeArbitraryResolver) {
        this.javaDefaultArbitraryGeneratorBuilder.javaTimeArbitraryResolver(javaTimeArbitraryResolver);
        return this;
    }

    public GenerateOptionsBuilder plugin(Plugin plugin) {
        plugin.accept(this);
        return this;
    }

    public GenerateOptionsBuilder arbitraryCustomizers(List<MatcherOperator<FixtureCustomizer>> arbitraryCustomizers) {
        this.arbitraryCustomizers = arbitraryCustomizers;
        return this;
    }

    public GenerateOptionsBuilder insertFirstFixtureCustomizer(MatcherOperator<FixtureCustomizer> arbitraryCustomizer) {
        List<MatcherOperator<FixtureCustomizer>> result = GenerateOptionsBuilder.insertFirst(this.arbitraryCustomizers, arbitraryCustomizer);
        return this.arbitraryCustomizers(result);
    }

    public GenerateOptionsBuilder insertFirstFixtureCustomizer(Matcher matcher, FixtureCustomizer<?> fixtureCustomizer) {
        return this.insertFirstFixtureCustomizer(new MatcherOperator<FixtureCustomizer>(matcher, fixtureCustomizer));
    }

    public <T> GenerateOptionsBuilder insertFirstFixtureCustomizer(Class<T> type, FixtureCustomizer<? extends T> fixtureCustomizer) {
        return this.insertFirstFixtureCustomizer(MatcherOperator.assignableTypeMatchOperator(type, fixtureCustomizer));
    }

    public GenerateOptionsBuilder defaultNotNull(boolean defaultNotNull) {
        this.defaultNotNull = defaultNotNull;
        return this;
    }

    public GenerateOptionsBuilder nullableContainer(boolean nullableContainer) {
        this.nullableContainer = nullableContainer;
        return this;
    }

    public GenerateOptionsBuilder nullableElement(boolean nullableElement) {
        this.nullableElement = nullableElement;
        return this;
    }

    public GenerateOptionsBuilder defaultArbitraryValidator(ArbitraryValidator arbitraryValidator) {
        this.defaultArbitraryValidator = arbitraryValidator;
        return this;
    }

    public GenerateOptions build() {
        ObjectPropertyGenerator defaultObjectPropertyGenerator = GenerateOptionsBuilder.defaultIfNull(this.defaultObjectPropertyGenerator, () -> GenerateOptions.DEFAULT_OBJECT_PROPERTY_GENERATOR);
        PropertyNameResolver defaultPropertyNameResolver = GenerateOptionsBuilder.defaultIfNull(this.defaultPropertyNameResolver, () -> GenerateOptions.DEFAULT_PROPERTY_NAME_RESOLVER);
        NullInjectGenerator defaultNullInjectGenerator = GenerateOptionsBuilder.defaultIfNull(this.defaultNullInjectGenerator, () -> new DefaultNullInjectGenerator(0.2, this.nullableContainer, this.defaultNotNull, this.nullableElement, new HashSet<String>(DefaultNullInjectGenerator.DEFAULT_NULLABLE_ANNOTATION_TYPES), new HashSet<String>(DefaultNullInjectGenerator.DEFAULT_NOTNULL_ANNOTATION_TYPES)));
        if (this.defaultNullInjectGeneratorOperator != null) {
            defaultNullInjectGenerator = (NullInjectGenerator)this.defaultNullInjectGeneratorOperator.apply(defaultNullInjectGenerator);
        }
        ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator = GenerateOptionsBuilder.defaultIfNull(this.defaultArbitraryContainerInfoGenerator, () -> context -> new ArbitraryContainerInfo(0, 3));
        ArbitraryGenerator defaultArbitraryGenerator = GenerateOptionsBuilder.defaultIfNull(this.defaultArbitraryGenerator, this.javaDefaultArbitraryGeneratorBuilder::build);
        return new GenerateOptions(this.propertyGenerators, this.defaultPropertyGenerator, this.arbitraryObjectPropertyGenerators, defaultObjectPropertyGenerator, this.containerPropertyGenerators, this.propertyNameResolvers, defaultPropertyNameResolver, this.nullInjectGenerators, defaultNullInjectGenerator, this.arbitraryContainerInfoGenerators, defaultArbitraryContainerInfoGenerator, this.arbitraryGenerators, defaultArbitraryGenerator, this.arbitraryCustomizers, this.defaultArbitraryValidator);
    }

    private static <T> T defaultIfNull(@Nullable T obj, Supplier<T> defaultValue) {
        return obj != null ? obj : defaultValue.get();
    }

    private static <T> List<T> insertFirst(List<T> list, T value) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(value);
        result.addAll(list);
        return result;
    }
}

