/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class CompositeProperty
implements Property {
    private final Property primaryProperty;
    private final Property secondaryProperty;

    public CompositeProperty(Property primaryProperty, Property secondaryProperty) {
        this.primaryProperty = primaryProperty;
        this.secondaryProperty = secondaryProperty;
    }

    public Property getPrimaryProperty() {
        return this.primaryProperty;
    }

    public Property getSecondaryProperty() {
        return this.secondaryProperty;
    }

    @Override
    public Type getType() {
        return this.primaryProperty.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.primaryProperty.getAnnotatedType();
    }

    @Override
    public String getName() {
        return this.primaryProperty.getName();
    }

    @Override
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        annotations.addAll(this.primaryProperty.getAnnotations());
        annotations.addAll(this.secondaryProperty.getAnnotations());
        return annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        Optional<T> annotation = this.primaryProperty.getAnnotation(annotationClass);
        if (!annotation.isPresent()) {
            annotation = this.secondaryProperty.getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    @Nullable
    public Object getValue(Object obj) {
        return this.primaryProperty.getValue(obj);
    }

    @Override
    @Nullable
    public Boolean isNullable() {
        return this.primaryProperty.isNullable();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeProperty that = (CompositeProperty)obj;
        return Objects.equals(this.primaryProperty, that.primaryProperty) && Objects.equals(this.secondaryProperty, that.secondaryProperty);
    }

    public int hashCode() {
        return Objects.hash(this.primaryProperty, this.secondaryProperty);
    }

    public String toString() {
        return "CompositeProperty{primaryProperty=" + this.primaryProperty + ", secondaryProperty=" + this.secondaryProperty + '}';
    }
}

