/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class FieldProperty
implements Property {
    private final AnnotatedType annotatedType;
    private final Field field;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public FieldProperty(Field field) {
        this(TypeCache.getAnnotatedType(field), field);
    }

    public FieldProperty(AnnotatedType annotatedType, Field field) {
        this.annotatedType = annotatedType;
        this.field = field;
        this.annotations = Arrays.asList(field.getAnnotations());
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldProperty that = (FieldProperty)obj;
        return this.annotatedType.getType().equals(that.annotatedType.getType()) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedType.getType(), this.annotations);
    }

    @Override
    @Nullable
    public Object getValue(Object obj) {
        try {
            this.field.setAccessible(true);
            return this.field.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Can not extract value. obj: " + obj.toString() + ", fieldName: " + this.field.getName(), ex);
        }
    }

    public String toString() {
        return "FieldProperty{annotatedType=" + this.annotatedType + ", field=" + this.field + '}';
    }
}

