/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapEntryElementProperty
implements Property {
    private final Property mapEntryProperty;
    private final Property keyProperty;
    private final Property valueProperty;
    private final Type type = MapEntryElementType.class;
    private final AnnotatedType annotatedType = Types.generateAnnotatedTypeWithoutAnnotation(this.type);

    public MapEntryElementProperty(Property mapEntryProperty, Property keyProperty, Property valueProperty) {
        this.mapEntryProperty = mapEntryProperty;
        this.keyProperty = keyProperty;
        this.valueProperty = valueProperty;
    }

    public Property getMapEntryProperty() {
        return this.mapEntryProperty;
    }

    public Property getKeyProperty() {
        return this.keyProperty;
    }

    public Property getValueProperty() {
        return this.valueProperty;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Object getValue(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> actualType = Types.getActualType(obj.getClass());
        if (!Map.class.isAssignableFrom(actualType) && !Map.Entry.class.isAssignableFrom(actualType)) {
            throw new IllegalArgumentException("given value is not Map or MapEntry type " + actualType);
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapEntryElementProperty that = (MapEntryElementProperty)obj;
        return this.mapEntryProperty.equals(that.mapEntryProperty) && this.keyProperty.equals(that.keyProperty) && this.valueProperty.equals(that.valueProperty);
    }

    public int hashCode() {
        return Objects.hash(this.mapEntryProperty, this.keyProperty, this.valueProperty);
    }

    public static final class MapEntryElementType {
        private Object key;
        @Nullable
        private Object value;

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public void setValue(@Nullable Object value) {
            this.value = value;
        }
    }
}

