/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class RootProperty
implements Property {
    private final AnnotatedType annotatedType;

    public RootProperty(AnnotatedType annotatedType) {
        this.annotatedType = annotatedType;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public String getName() {
        return "$";
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public Object getValue(Object obj) {
        if (Types.getActualType(this.annotatedType.getType()) == obj.getClass()) {
            return obj;
        }
        throw new IllegalArgumentException("RootProperty obj is not a root type. annotatedType: " + this.annotatedType + ", objType: " + obj.getClass());
    }

    public String toString() {
        return "RootProperty{annotatedType=" + this.annotatedType + '}';
    }
}

