/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.type.TypeCache;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public class Types {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    public static Class<?> getActualType(AnnotatedType annotatedType) {
        return Types.getActualType(annotatedType.getType());
    }

    public static Class<?> getActualType(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (WildcardType.class.isAssignableFrom(type.getClass())) {
            WildcardType wildcardType = (WildcardType)type;
            Type upperBound = wildcardType.getUpperBounds()[0];
            return Types.getActualType(upperBound);
        }
        if (TypeVariable.class.isAssignableFrom(type.getClass())) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (genericDeclaration.getClass() == Class.class) {
                return Object.class;
            }
            throw new UnsupportedOperationException("Unsupported TypeVariable's generationDeclaration type. type: " + genericDeclaration.getClass());
        }
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return Types.getActualType(rawType);
        }
        throw new UnsupportedOperationException("Unsupported Type to get actualType. type: " + type.getClass());
    }

    public static List<AnnotatedType> getGenericsTypes(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type.getClass() == Class.class) {
            return Collections.emptyList();
        }
        if (AnnotatedWildcardType.class.isAssignableFrom(annotatedType.getClass())) {
            AnnotatedWildcardType wildcardType = (AnnotatedWildcardType)annotatedType;
            return Types.getGenericsTypes(wildcardType.getAnnotatedUpperBounds()[0]);
        }
        if (TypeVariable.class.isAssignableFrom(type.getClass())) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (genericDeclaration.getClass() == Class.class) {
                return Collections.emptyList();
            }
            throw new UnsupportedOperationException("Unsupported TypeVariable's generationDeclaration type. type: " + genericDeclaration.getClass());
        }
        if (AnnotatedParameterizedType.class.isAssignableFrom(annotatedType.getClass())) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType[] rawTypes = parameterizedType.getAnnotatedActualTypeArguments();
            if (rawTypes == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(rawTypes);
        }
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            return Arrays.stream(actualTypeArguments).map(Types::generateAnnotatedTypeWithoutAnnotation).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Unsupported Type to get genericsTypes. annotatedType: " + annotatedType);
    }

    public static AnnotatedType resolveWithTypeReferenceGenerics(AnnotatedType ownerType, Field field) {
        if (!(ownerType instanceof AnnotatedParameterizedType)) {
            final AnnotatedType fieldAnnotatedType = field.getAnnotatedType();
            Class<?> actualOwnerType = Types.getActualType(ownerType.getType());
            AnnotatedType annotatedSuperClassType = actualOwnerType.getAnnotatedSuperclass();
            if (annotatedSuperClassType != null && ParameterizedType.class.isAssignableFrom(annotatedSuperClassType.getType().getClass())) {
                ParameterizedType parameterizedType = (ParameterizedType)annotatedSuperClassType.getType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                Type genericType = field.getGenericType();
                if (genericType instanceof TypeVariable) {
                    final Type actualType = (Type)((Object)Types.getTypeVariableIndex((TypeVariable)genericType).map(index -> actualTypeArguments[index]).orElse((Type)((Object)Object.class)));
                    return new AnnotatedType(){

                        @Override
                        public Type getType() {
                            return actualType;
                        }

                        @Override
                        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                            return fieldAnnotatedType.getAnnotation(annotationClass);
                        }

                        @Override
                        public Annotation[] getAnnotations() {
                            return fieldAnnotatedType.getAnnotations();
                        }

                        @Override
                        public Annotation[] getDeclaredAnnotations() {
                            return fieldAnnotatedType.getDeclaredAnnotations();
                        }
                    };
                }
            }
            return fieldAnnotatedType;
        }
        AnnotatedParameterizedType ownerAnnotatedParameterizedType = (AnnotatedParameterizedType)ownerType;
        AnnotatedType[] ownerGenericsTypes = ownerAnnotatedParameterizedType.getAnnotatedActualTypeArguments();
        if (ownerGenericsTypes == null || ownerGenericsTypes.length == 0) {
            return field.getAnnotatedType();
        }
        ParameterizedType parameterizedType = (ParameterizedType)ownerAnnotatedParameterizedType.getType();
        Class<?> ownerActualType = Types.getActualType(parameterizedType.getRawType());
        List<TypeVariable<Class<?>>> ownerTypeVariableParameters = Arrays.asList(ownerActualType.getTypeParameters());
        Type fieldGenericsType = field.getGenericType();
        if (TypeVariable.class.isAssignableFrom(fieldGenericsType.getClass())) {
            int index2 = ownerTypeVariableParameters.indexOf(fieldGenericsType);
            return ownerGenericsTypes[index2];
        }
        if (!(fieldGenericsType instanceof ParameterizedType)) {
            return field.getAnnotatedType();
        }
        final AnnotatedParameterizedType fieldParameterizedType = (AnnotatedParameterizedType)field.getAnnotatedType();
        AnnotatedType[] fieldGenericsTypes = fieldParameterizedType.getAnnotatedActualTypeArguments();
        if (fieldGenericsTypes == null || fieldGenericsTypes.length == 0) {
            return fieldParameterizedType;
        }
        final AnnotatedType[] resolvedGenericsTypes = new AnnotatedType[fieldGenericsTypes.length];
        final Type[] resolvedTypes = new Type[fieldGenericsTypes.length];
        for (int i = 0; i < fieldGenericsTypes.length; ++i) {
            AnnotatedType generics = fieldGenericsTypes[i];
            if (generics instanceof AnnotatedParameterizedType || generics.getType().getClass() == Class.class) {
                resolvedGenericsTypes[i] = generics;
                resolvedTypes[i] = generics.getType();
                continue;
            }
            if (!TypeVariable.class.isAssignableFrom(generics.getType().getClass())) continue;
            TypeVariable typeVariable = (TypeVariable)generics.getType();
            int index3 = ownerTypeVariableParameters.indexOf(typeVariable);
            resolvedGenericsTypes[i] = generics = ownerGenericsTypes[index3];
            resolvedTypes[i] = generics.getType();
        }
        final ParameterizedType type = (ParameterizedType)fieldParameterizedType.getType();
        final ParameterizedType resolveType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return resolvedTypes;
            }

            @Override
            public Type getRawType() {
                return type.getRawType();
            }

            @Override
            public Type getOwnerType() {
                return type.getOwnerType();
            }
        };
        return new AnnotatedParameterizedType(){

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return resolvedGenericsTypes;
            }

            @Override
            public AnnotatedType getAnnotatedOwnerType() {
                return null;
            }

            @Override
            public Type getType() {
                return resolveType;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return fieldParameterizedType.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return fieldParameterizedType.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return fieldParameterizedType.getDeclaredAnnotations();
            }
        };
    }

    public static AnnotatedType resolveWithTypeReferenceGenerics(AnnotatedType ownerType, PropertyDescriptor propertyDescriptor) {
        if (!(ownerType instanceof AnnotatedParameterizedType)) {
            final AnnotatedType propertyAnnotatedType = TypeCache.getAnnotatedType(propertyDescriptor);
            if (TypeVariable.class.isAssignableFrom(propertyAnnotatedType.getType().getClass())) {
                return new AnnotatedType(){

                    @Override
                    public Type getType() {
                        return Object.class;
                    }

                    @Override
                    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                        return propertyAnnotatedType.getAnnotation(annotationClass);
                    }

                    @Override
                    public Annotation[] getAnnotations() {
                        return propertyAnnotatedType.getAnnotations();
                    }

                    @Override
                    public Annotation[] getDeclaredAnnotations() {
                        return propertyAnnotatedType.getDeclaredAnnotations();
                    }
                };
            }
            return propertyAnnotatedType;
        }
        AnnotatedParameterizedType ownerAnnotatedParameterizedType = (AnnotatedParameterizedType)ownerType;
        AnnotatedType[] ownerGenericsTypes = ownerAnnotatedParameterizedType.getAnnotatedActualTypeArguments();
        if (ownerGenericsTypes == null || ownerGenericsTypes.length == 0) {
            return TypeCache.getAnnotatedType(propertyDescriptor);
        }
        ParameterizedType parameterizedType = (ParameterizedType)ownerAnnotatedParameterizedType.getType();
        Class<?> ownerActualType = Types.getActualType(parameterizedType.getRawType());
        List<TypeVariable<Class<?>>> ownerTypeVariableParameters = Arrays.asList(ownerActualType.getTypeParameters());
        Method readMethod = propertyDescriptor.getReadMethod();
        Type methodGenericsType = readMethod.getGenericReturnType();
        if (TypeVariable.class.isAssignableFrom(methodGenericsType.getClass())) {
            int index = ownerTypeVariableParameters.indexOf(methodGenericsType);
            return ownerGenericsTypes[index];
        }
        if (!(methodGenericsType instanceof ParameterizedType)) {
            return TypeCache.getAnnotatedType(propertyDescriptor);
        }
        final AnnotatedParameterizedType propertyParameterizedType = (AnnotatedParameterizedType)TypeCache.getAnnotatedType(propertyDescriptor);
        AnnotatedType[] propertyGenericsTypes = propertyParameterizedType.getAnnotatedActualTypeArguments();
        if (propertyGenericsTypes == null || propertyGenericsTypes.length == 0) {
            return propertyParameterizedType;
        }
        final AnnotatedType[] resolvedGenericsTypes = new AnnotatedType[propertyGenericsTypes.length];
        final Type[] resolvedTypes = new Type[propertyGenericsTypes.length];
        for (int i = 0; i < propertyGenericsTypes.length; ++i) {
            AnnotatedType generics = propertyGenericsTypes[i];
            if (generics instanceof AnnotatedParameterizedType || generics.getType().getClass() == Class.class) {
                resolvedGenericsTypes[i] = generics;
                resolvedTypes[i] = generics.getType();
                continue;
            }
            if (!TypeVariable.class.isAssignableFrom(generics.getType().getClass())) continue;
            TypeVariable typeVariable = (TypeVariable)generics.getType();
            int index = ownerTypeVariableParameters.indexOf(typeVariable);
            resolvedGenericsTypes[i] = generics = ownerGenericsTypes[index];
            resolvedTypes[i] = generics.getType();
        }
        final ParameterizedType type = (ParameterizedType)propertyParameterizedType.getType();
        final ParameterizedType resolveType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return resolvedTypes;
            }

            @Override
            public Type getRawType() {
                return type.getRawType();
            }

            @Override
            public Type getOwnerType() {
                return type.getOwnerType();
            }
        };
        return new AnnotatedParameterizedType(){

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return resolvedGenericsTypes;
            }

            @Override
            public AnnotatedType getAnnotatedOwnerType() {
                return null;
            }

            @Override
            public Type getType() {
                return resolveType;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return propertyParameterizedType.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return propertyParameterizedType.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return propertyParameterizedType.getDeclaredAnnotations();
            }
        };
    }

    public static AnnotatedType getArrayComponentAnnotatedType(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
            return annotatedArrayType.getAnnotatedGenericComponentType();
        }
        Class<?> type = Types.getActualType(annotatedType.getType());
        if (type.isArray()) {
            return Types.generateAnnotatedTypeWithoutAnnotation(type.getComponentType());
        }
        throw new IllegalArgumentException("given type is not Array type, annotatedType: " + annotatedType);
    }

    public static Class<?> getArrayComponentType(AnnotatedType annotatedType) {
        return Types.getActualType(Types.getArrayComponentAnnotatedType(annotatedType));
    }

    public static AnnotatedType generateAnnotatedTypeWithoutAnnotation(final Type type) {
        return new AnnotatedType(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }
        };
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        return Types.isAssignable(cls, toClass, true);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = Types.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = Types.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls) || Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private static Optional<Integer> getTypeVariableIndex(TypeVariable<?> typeVariable) {
        TypeVariable<?>[] tVars = typeVariable.getGenericDeclaration().getTypeParameters();
        int index = -1;
        for (TypeVariable<?> v : tVars) {
            ++index;
            if (!typeVariable.equals(v)) continue;
            return Optional.of(index);
        }
        return Optional.empty();
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        wrapperPrimitiveMap = new HashMap();
        primitiveWrapperMap.forEach((primitiveClass, wrapperClass) -> {
            if (!primitiveClass.equals(wrapperClass)) {
                wrapperPrimitiveMap.put((Class<?>)wrapperClass, (Class<?>)primitiveClass);
            }
        });
    }

    public static class UnidentifiableType {
        private UnidentifiableType() {
        }
    }
}

