/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.unique;

import java.util.Optional;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.ArbitraryDelegator;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.JustArbitrary;
import org.apiguardian.api.API;

@API(since="0.4.3", status=API.Status.MAINTAINED)
public final class FilteredMonkeyArbitrary<T>
extends ArbitraryDelegator<T> {
    private final Predicate<T> filterPredicate;
    private final int maxMisses;

    public FilteredMonkeyArbitrary(Arbitrary<T> self, Predicate<T> filterPredicate, int maxMisses) {
        super(self);
        this.filterPredicate = filterPredicate;
        this.maxMisses = maxMisses;
    }

    public RandomGenerator<T> generator(int genSize) {
        if (this.isFixed()) {
            return super.generator(genSize);
        }
        return super.generator(genSize).filter(this.filterPredicate, this.maxMisses);
    }

    public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        if (this.isFixed()) {
            return super.generatorWithEmbeddedEdgeCases(genSize);
        }
        return super.generatorWithEmbeddedEdgeCases(genSize).filter(this.filterPredicate, this.maxMisses);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        if (this.isFixed()) {
            return super.exhaustive(maxNumberOfSamples);
        }
        return super.exhaustive(maxNumberOfSamples).map(generator -> generator.filter(this.filterPredicate, this.maxMisses));
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        if (this.isFixed()) {
            return super.edgeCases(maxEdgeCases);
        }
        return EdgeCasesSupport.filter((EdgeCases)super.edgeCases(maxEdgeCases), this.filterPredicate);
    }

    private boolean isFixed() {
        return this.arbitrary() instanceof JustArbitrary;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FilteredMonkeyArbitrary that = (FilteredMonkeyArbitrary)((Object)obj);
        if (this.maxMisses != that.maxMisses) {
            return false;
        }
        return LambdaSupport.areEqual(this.filterPredicate, that.filterPredicate);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxMisses;
        return result;
    }
}

