/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.collection;

import com.navercorp.fixturemonkey.api.collection.LruCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class IteratorCache {
    private static final LruCache<Iterator<?>, List<?>> ITERATOR_TO_LIST = new LruCache(2000);

    public static List<?> getList(Iterator<?> iterator) {
        if (ITERATOR_TO_LIST.containsKey(iterator)) {
            return (List)ITERATOR_TO_LIST.get(iterator);
        }
        List<?> list = IteratorCache.toList(iterator);
        ITERATOR_TO_LIST.put(iterator, list);
        return list;
    }

    private static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }
}

