/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.collection;

import com.navercorp.fixturemonkey.api.collection.LruCache;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class StreamCache {
    private static final LruCache<Stream<?>, List<?>> STREAM_TO_LIST = new LruCache(2000);

    public static List<?> getList(Stream<?> stream) {
        if (STREAM_TO_LIST.containsKey(stream)) {
            return (List)STREAM_TO_LIST.get(stream);
        }
        List list = stream.collect(Collectors.toList());
        STREAM_TO_LIST.put(stream, list);
        return list;
    }
}

