/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import org.apiguardian.api.API;

@API(since="0.4.3", status=API.Status.MAINTAINED)
public final class MonkeyGeneratorContext {
    private final SortedMap<ArbitraryGeneratorContext.PropertyPath, Set<Object>> uniqueSetsByProperty;

    public MonkeyGeneratorContext(SortedMap<ArbitraryGeneratorContext.PropertyPath, Set<Object>> uniqueSetsByProperty) {
        this.uniqueSetsByProperty = uniqueSetsByProperty;
    }

    public synchronized boolean isUniqueAndCheck(ArbitraryGeneratorContext.PropertyPath property, Object value) {
        boolean unique;
        Set set = this.uniqueSetsByProperty.computeIfAbsent(property, p -> new HashSet());
        boolean bl = unique = !set.contains(value);
        if (unique) {
            set.add(value);
            return true;
        }
        return false;
    }

    public void evictUnique(ArbitraryGeneratorContext.PropertyPath propertyPath) {
        if (this.uniqueSetsByProperty.containsKey(propertyPath)) {
            ((Set)this.uniqueSetsByProperty.get(propertyPath)).clear();
        }
    }
}

