/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryProperty {
    private final ObjectProperty objectProperty;
    @Nullable
    private final ContainerProperty containerProperty;

    public ArbitraryProperty(ObjectProperty objectProperty, @Nullable ContainerProperty containerProperty) {
        this.objectProperty = objectProperty;
        this.containerProperty = containerProperty;
    }

    public ObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    @Nullable
    public ContainerProperty getContainerProperty() {
        return this.containerProperty;
    }

    public ArbitraryProperty withNullInject(double nullInject) {
        return new ArbitraryProperty(this.objectProperty.withNullInject(nullInject), this.containerProperty);
    }

    public ArbitraryProperty withElementProperties(List<Property> elementProperties) {
        return new ArbitraryProperty(this.objectProperty, this.containerProperty.withElementProperties(elementProperties));
    }

    public ArbitraryProperty withChildPropertyListsByCandidateProperty(Map<Property, List<Property>> childPropertyListsByCandidateProperty) {
        return new ArbitraryProperty(this.objectProperty.withChildPropertyListsByCandidateProperty(childPropertyListsByCandidateProperty), this.containerProperty);
    }

    public ArbitraryProperty withContainerInfo(ArbitraryContainerInfo containerInfo) {
        return new ArbitraryProperty(this.objectProperty, this.containerProperty.withContainerInfo(containerInfo));
    }

    public ArbitraryProperty withContainerProperty(ContainerProperty containerProperty) {
        return new ArbitraryProperty(this.objectProperty, containerProperty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryProperty that = (ArbitraryProperty)obj;
        return this.objectProperty.equals(that.objectProperty) && Objects.equals(this.containerProperty, that.containerProperty);
    }

    public int hashCode() {
        return Objects.hash(this.objectProperty, this.containerProperty);
    }
}

