/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.FixedCombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ChildArbitraryContext {
    private final Property parentProperty;
    private final Map<ArbitraryProperty, CombinableArbitrary> arbitrariesByChildProperty;

    public ChildArbitraryContext(Property parentProperty, Map<ArbitraryProperty, CombinableArbitrary> arbitrariesByChildProperty) {
        this.parentProperty = parentProperty;
        this.arbitrariesByChildProperty = arbitrariesByChildProperty;
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    public void replaceArbitrary(Matcher matcher, Arbitrary<?> arbitrary) {
        for (Map.Entry<ArbitraryProperty, CombinableArbitrary> arbitraryByChildProperty : this.arbitrariesByChildProperty.entrySet()) {
            ArbitraryProperty arbitraryProperty = arbitraryByChildProperty.getKey();
            ObjectProperty objectProperty = arbitraryProperty.getObjectProperty();
            if (!matcher.match(objectProperty.getProperty())) continue;
            this.arbitrariesByChildProperty.put(arbitraryProperty, new FixedCombinableArbitrary((Arbitrary<Object>)arbitrary.asGeneric()));
        }
    }

    public void removeArbitrary(Matcher matcher) {
        this.arbitrariesByChildProperty.entrySet().removeIf(it -> matcher.match(((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty()));
    }

    public Map<String, CombinableArbitrary> getCombinableArbitrariesByResolvedName() {
        return this.arbitrariesByChildProperty.entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getResolvedPropertyName(), Map.Entry::getValue));
    }

    public Map<String, CombinableArbitrary> getCombinableArbitraryByPropertyName() {
        return this.arbitrariesByChildProperty.entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty().getName(), Map.Entry::getValue));
    }

    public List<CombinableArbitrary> getElementArbitraries() {
        return new ArrayList<CombinableArbitrary>(this.arbitrariesByChildProperty.values());
    }
}

