/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.MapKeyElementProperty;
import com.navercorp.fixturemonkey.api.property.MapValueElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class EntryContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final EntryContainerPropertyGenerator INSTANCE = new EntryContainerPropertyGenerator();
    private static final ArbitraryContainerInfo CONTAINER_INFO = new ArbitraryContainerInfo(1, 1);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        if (genericsTypes.size() != 2) {
            throw new IllegalArgumentException("Entry genericsTypes must be have 2 generics type for key and value. propertyType: " + property.getType() + ", genericsTypes: " + genericsTypes);
        }
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        if (containerInfo == null) {
            containerInfo = CONTAINER_INFO;
        }
        int size = containerInfo.getRandomSize();
        AnnotatedType keyType = genericsTypes.get(0);
        AnnotatedType valueType = genericsTypes.get(1);
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new MapEntryElementProperty(property, new MapKeyElementProperty(property, keyType, sequence), new MapValueElementProperty(property, valueType, sequence)));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

