/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.MethodProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.EXPERIMENTAL)
public final class AnonymousArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final AnonymousArbitraryIntrospector INSTANCE = new AnonymousArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        Map<String, CombinableArbitrary> arbitrariesByPropertyName = context.getCombinableArbitrariesByPropertyName();
        List<ArbitraryProperty> childrenProperties = context.getChildren();
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> new InvocationHandlerBuilder(new HashMap()));
        for (ArbitraryProperty arbitraryProperty : childrenProperties) {
            Property childProperty = arbitraryProperty.getObjectProperty().getProperty();
            if (!(childProperty instanceof MethodProperty)) continue;
            MethodProperty methodProperty = (MethodProperty)childProperty;
            builderCombinator = builderCombinator.use(arbitrariesByPropertyName.get(childProperty.getName()).combined()).in((builder, value) -> {
                ((InvocationHandlerBuilder)builder).put(methodProperty.getMethodName(), value);
                return builder;
            });
        }
        return new ArbitraryIntrospectorResult(builderCombinator.build(builder -> {
            if (((InvocationHandlerBuilder)builder).generatedValuesByMethodName.isEmpty()) {
                return null;
            }
            return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, ((InvocationHandlerBuilder)builder).build()));
        }));
    }

    private static final class InvocationHandlerBuilder {
        private final Map<String, Object> generatedValuesByMethodName;

        private InvocationHandlerBuilder(Map<String, Object> generatedValuesByMethodName) {
            this.generatedValuesByMethodName = generatedValuesByMethodName;
        }

        private void put(String methodName, Object value) {
            this.generatedValuesByMethodName.put(methodName, value);
        }

        private InvocationHandler build() {
            return (proxy, method, args) -> this.generatedValuesByMethodName.get(method.getName());
        }
    }
}

