/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.LazyCombinableArbitrary;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArrayIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        return Types.getActualType(property.getType()).isArray();
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        return new ArbitraryIntrospectorResult(new LazyCombinableArbitrary(LazyArbitrary.lazy(() -> {
            List childrenArbitraries = context.getElementArbitraries().stream().map(CombinableArbitrary::combined).collect(Collectors.toList());
            Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> new ArrayBuilder(Types.getArrayComponentType(property.getObjectProperty().getProperty().getAnnotatedType()), childrenArbitraries.size()));
            for (Arbitrary childArbitrary : childrenArbitraries) {
                builderCombinator = builderCombinator.use(childArbitrary).in((list, element) -> {
                    list.add(element);
                    return list;
                });
            }
            return builderCombinator.build(ArrayBuilder::build);
        })));
    }

    private static final class ArrayBuilder {
        private final List<Object> array = new ArrayList<Object>();
        private final Class<?> componentType;
        private final int size;

        public ArrayBuilder(Class<?> componentType, int size) {
            this.componentType = componentType;
            this.size = size;
        }

        ArrayBuilder add(Object value) {
            if (this.array.size() >= this.size) {
                return this;
            }
            this.array.add(value);
            return this;
        }

        Object build() {
            Object array = Array.newInstance(this.componentType, this.size);
            for (int i = 0; i < this.array.size(); ++i) {
                Array.set(array, i, this.array.get(i));
            }
            return array;
        }
    }
}

