/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.LazyCombinableArbitrary;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class BeanArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final BeanArbitraryIntrospector INSTANCE = new BeanArbitraryIntrospector();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<ArbitraryProperty> childrenProperties = context.getChildren();
        Map<String, CombinableArbitrary> arbitrariesByResolvedName = context.getCombinableArbitrariesByResolvedName();
        Map<String, PropertyDescriptor> propertyDescriptors = PropertyCache.getPropertyDescriptorsByPropertyName(property.getAnnotatedType());
        LazyArbitrary<Arbitrary<Object>> generateArbitrary = LazyArbitrary.lazy(() -> {
            Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> Reflections.newInstance(type));
            for (ArbitraryProperty arbitraryProperty : childrenProperties) {
                String resolvePropertyName;
                CombinableArbitrary combinableArbitrary;
                String originPropertyName = arbitraryProperty.getObjectProperty().getProperty().getName();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescriptors.get(originPropertyName);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod == null || (combinableArbitrary = (CombinableArbitrary)arbitrariesByResolvedName.get(resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName())) == null) continue;
                builderCombinator = builderCombinator.use(combinableArbitrary.combined()).in((b, v) -> {
                    try {
                        if (v != null) {
                            writeMethod.invoke(b, v);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.log.warn("set bean property is failed. name: {} value: {}", new Object[]{writeMethod.getName(), v, e});
                    }
                    return b;
                });
            }
            return builderCombinator.build();
        });
        return new ArbitraryIntrospectorResult(new LazyCombinableArbitrary(generateArbitrary));
    }
}

