/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.LazyCombinableArbitrary;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class BuilderArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final BuilderArbitraryIntrospector INSTANCE = new BuilderArbitraryIntrospector();
    private static final Map<Class<?>, Method> BUILDER_CACHE = new ConcurrentHashMap(2000);
    private static final Map<String, Method> BUILD_FIELD_METHOD_CACHE = new ConcurrentHashMap<String, Method>(2000);
    private static final Map<Class<?>, Method> BUILD_METHOD_CACHE = new ConcurrentHashMap(2000);
    private static final Map<Class<?>, Class<?>> BUILDER_TYPE_CACHE = new ConcurrentHashMap(2000);
    private final Map<Class<?>, String> typedBuilderMethodName = new ConcurrentHashMap(2000);
    private final Map<Class<?>, String> typedBuildMethodName = new ConcurrentHashMap(2000);
    private String defaultBuildMethodName = "build";
    private String defaultBuilderMethodName = "builder";

    private static void clearMethodCache() {
        BUILDER_CACHE.clear();
        BUILD_FIELD_METHOD_CACHE.clear();
        BUILD_METHOD_CACHE.clear();
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List<ArbitraryProperty> childrenProperties = context.getChildren();
        Map<String, CombinableArbitrary> arbitrariesByResolvedName = context.getCombinableArbitrariesByResolvedName();
        LazyArbitrary<Arbitrary<Object>> generateArbitrary = LazyArbitrary.lazy(() -> {
            Class<?> builderType = this.getBuilderType(type);
            Method builderMethod = BUILDER_CACHE.get(type);
            Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> Reflections.invokeMethod(builderMethod, null, new Object[0]));
            for (ArbitraryProperty arbitraryProperty : childrenProperties) {
                String methodName = this.getFieldName(arbitraryProperty.getObjectProperty().getProperty());
                Class<?> actualType = this.getActualType(arbitraryProperty.getObjectProperty().getProperty());
                String buildFieldMethodName = builderType.getName() + "#" + methodName;
                String resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName();
                CombinableArbitrary combinableArbitrary = (CombinableArbitrary)arbitrariesByResolvedName.get(resolvePropertyName);
                Method method = BUILD_FIELD_METHOD_CACHE.computeIfAbsent(buildFieldMethodName, f -> {
                    Method buildFieldMethod = Reflections.findMethod(builderType, methodName, actualType);
                    if (buildFieldMethod != null) {
                        buildFieldMethod.setAccessible(true);
                    }
                    return buildFieldMethod;
                });
                if (method == null) continue;
                builderCombinator = builderCombinator.use(combinableArbitrary.combined()).in((b, v) -> v != null ? Reflections.invokeMethod(method, b, v) : b);
            }
            Method buildMethod = BUILD_METHOD_CACHE.computeIfAbsent(builderType, t -> {
                String buildMethodName = this.typedBuildMethodName.getOrDefault(t, this.defaultBuildMethodName);
                Method method = Reflections.findMethod(builderType, buildMethodName, new Class[0]);
                if (method == null) {
                    throw new IllegalStateException("Can not find BuilderCombiner build method for clazz. clazz: " + type);
                }
                method.setAccessible(true);
                return method;
            });
            return builderCombinator.build(b -> {
                if (b == null) {
                    return null;
                }
                return Reflections.invokeMethod(buildMethod, b, new Object[0]);
            });
        });
        return new ArbitraryIntrospectorResult(new LazyCombinableArbitrary(generateArbitrary));
    }

    public void setDefaultBuilderMethodName(String defaultBuilderMethodName) {
        this.defaultBuilderMethodName = defaultBuilderMethodName;
        BuilderArbitraryIntrospector.clearMethodCache();
    }

    public void setDefaultBuildMethodName(String defaultBuildMethodName) {
        this.defaultBuildMethodName = defaultBuildMethodName;
        BuilderArbitraryIntrospector.clearMethodCache();
    }

    public void setBuilderMethodName(Class<?> type, String builderMethodName) {
        this.typedBuilderMethodName.put(type, builderMethodName);
        BuilderArbitraryIntrospector.clearMethodCache();
    }

    public void setBuildMethodName(Class<?> type, String buildMethodName) {
        this.typedBuildMethodName.put(type, buildMethodName);
        BuilderArbitraryIntrospector.clearMethodCache();
    }

    private Class<?> getBuilderType(Class<?> objectType) {
        Method builderMethod = BUILDER_CACHE.computeIfAbsent(objectType, t -> {
            String builderMethodName = this.typedBuilderMethodName.getOrDefault(t, this.defaultBuilderMethodName);
            Method method = Reflections.findMethod(t, builderMethodName, new Class[0]);
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        });
        if (builderMethod == null) {
            throw new IllegalArgumentException("Class has no builder class. " + objectType.getName());
        }
        return BUILDER_TYPE_CACHE.computeIfAbsent(objectType, t -> {
            Object builder = Reflections.invokeMethod(builderMethod, null, new Object[0]);
            return builder.getClass();
        });
    }

    private String getFieldName(Property property) {
        return this.getActualProperty(property).getName();
    }

    private Class<?> getActualType(Property property) {
        return Types.getActualType(this.getActualProperty(property).getType());
    }

    private Property getActualProperty(Property property) {
        if (property instanceof CompositeProperty) {
            CompositeProperty compositeProperty = (CompositeProperty)property;
            if (compositeProperty.getPrimaryProperty() instanceof FieldProperty) {
                return ((CompositeProperty)property).getPrimaryProperty();
            }
            if (compositeProperty.getSecondaryProperty() instanceof FieldProperty) {
                return ((CompositeProperty)property).getSecondaryProperty();
            }
        }
        return property;
    }
}

