/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.FixedCombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.LazyCombinableArbitrary;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public final class ConstructorPropertiesArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final ConstructorPropertiesArbitraryIntrospector INSTANCE = new ConstructorPropertiesArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        Map<String, CombinableArbitrary> arbitrariesByResolvedName = context.getCombinableArbitrariesByResolvedName();
        Map.Entry<Constructor<?>, String[]> parameterNamesByConstructor = PropertyCache.getParameterNamesByConstructor(type);
        if (parameterNamesByConstructor == null) {
            throw new IllegalArgumentException("Primary Constructor does not exist. type " + type.getSimpleName());
        }
        Constructor<?> primaryConstructor = parameterNamesByConstructor.getKey();
        String[] parameterNames = parameterNamesByConstructor.getValue();
        int parameterSize = parameterNames.length;
        LazyArbitrary<Arbitrary<Object>> generateArbitrary = LazyArbitrary.lazy(() -> {
            Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> new ArrayList(parameterSize));
            for (String parameterName : parameterNames) {
                CombinableArbitrary combinableArbitrary = arbitrariesByResolvedName.getOrDefault(parameterName, new FixedCombinableArbitrary((Arbitrary<Object>)Arbitraries.just(null)));
                builderCombinator = builderCombinator.use(combinableArbitrary.combined()).in((list, value) -> {
                    list.add(value);
                    return list;
                });
            }
            return builderCombinator.build(list -> Reflections.newInstance(primaryConstructor, list.toArray()));
        });
        return new ArbitraryIntrospectorResult(new LazyCombinableArbitrary(generateArbitrary));
    }
}

