/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.JavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class JavaArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private final Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector;

    public JavaArbitraryIntrospector() {
        this(new JavaTypeArbitraryGenerator(){}, new JavaArbitraryResolver(){});
    }

    public JavaArbitraryIntrospector(JavaTypeArbitraryGenerator arbitraryGenerator, JavaArbitraryResolver arbitraryResolver) {
        this.introspector = JavaArbitraryIntrospector.introspectors(arbitraryGenerator, arbitraryResolver);
    }

    @Override
    public boolean match(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        return this.introspector.containsKey(actualType);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Class<?> type = Types.getActualType(context.getResolvedType());
        return this.introspector.getOrDefault(type, ctx -> ArbitraryIntrospectorResult.EMPTY).apply(context);
    }

    private static Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspectors(JavaTypeArbitraryGenerator arbitraryGenerator, JavaArbitraryResolver arbitraryResolver) {
        HashMap<Class<BigDecimal>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector = new HashMap<Class<BigDecimal>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>>();
        introspector.put(String.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.strings(arbitraryGenerator.strings(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Character.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.characters(arbitraryGenerator.characters(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Character.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.characters(arbitraryGenerator.characters(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Short.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.shorts(arbitraryGenerator.shorts(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Short.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.shorts(arbitraryGenerator.shorts(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Byte.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.bytes(arbitraryGenerator.bytes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Byte.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.bytes(arbitraryGenerator.bytes(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Double.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.doubles(arbitraryGenerator.doubles(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Double.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.doubles(arbitraryGenerator.doubles(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Float.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.floats(arbitraryGenerator.floats(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Float.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.floats(arbitraryGenerator.floats(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Integer.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.integers(arbitraryGenerator.integers(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Integer.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.integers(arbitraryGenerator.integers(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Long.TYPE, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.longs(arbitraryGenerator.longs(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(Long.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.longs(arbitraryGenerator.longs(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(BigInteger.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.bigIntegers(arbitraryGenerator.bigIntegers(), (ArbitraryGeneratorContext)ctx)));
        introspector.put(BigDecimal.class, ctx -> new ArbitraryIntrospectorResult(arbitraryResolver.bigDecimals(arbitraryGenerator.bigDecimals(), (ArbitraryGeneratorContext)ctx)));
        return Collections.unmodifiableMap(introspector);
    }
}

