/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.5.6", status=API.Status.MAINTAINED)
public final class MapEntryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Map.Entry.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        ContainerProperty containerProperty = property.getContainerProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container property should not null. type : " + property.getObjectProperty().getProperty().getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        List childrenArbitraries = context.getElementArbitraries().stream().map(CombinableArbitrary::combined).collect(Collectors.toList());
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        if (childrenArbitraries.size() != 1) {
            throw new IllegalArgumentException("Map entry node should have only one child, current : " + childrenArbitraries.size());
        }
        Arbitrary arbitrary = ((Arbitrary)childrenArbitraries.get(0)).map(it -> (MapEntryElementProperty.MapEntryElementType)it).filter(Objects::nonNull).map(it -> new AbstractMap.SimpleEntry<Object, Object>(it.getKey(), it.getValue()));
        return new ArbitraryIntrospectorResult(arbitrary);
    }
}

