/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.MonkeyCombineArbitrary;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Matcher MATCHER = new AssignableTypeMatcher(Map.class);

    @Override
    public boolean match(Property property) {
        return MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty arbitraryProperty = context.getArbitraryProperty();
        ContainerProperty containerProperty = arbitraryProperty.getContainerProperty();
        Property property = arbitraryProperty.getObjectProperty().getProperty();
        if (containerProperty == null) {
            throw new IllegalArgumentException("container arbitraryProperty should not null. property : " + property.getName());
        }
        ArbitraryContainerInfo containerInfo = containerProperty.getContainerInfo();
        if (containerInfo == null) {
            return ArbitraryIntrospectorResult.EMPTY;
        }
        List childrenArbitraries = context.getElementArbitraries().stream().map(CombinableArbitrary::combined).collect(Collectors.toList());
        MonkeyCombineArbitrary mapArbitrary = new MonkeyCombineArbitrary(list -> {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Object obj : list) {
                MapEntryElementProperty.MapEntryElementType mapEntryElement = (MapEntryElementProperty.MapEntryElementType)obj;
                if (mapEntryElement.getKey() == null) {
                    throw new IllegalArgumentException("Map key cannot be null.");
                }
                map.put(mapEntryElement.getKey(), mapEntryElement.getValue());
            }
            return map;
        }, () -> context.evictUnique(context.getPathProperty()), childrenArbitraries);
        return new ArbitraryIntrospectorResult(mapArbitrary);
    }
}

