/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.MethodProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.EXPERIMENTAL)
public final class InterfaceJavaMethodProperty
implements MethodProperty {
    private final AnnotatedType returnAnnotatedType;
    private final String name;
    private final String methodName;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public InterfaceJavaMethodProperty(AnnotatedType returnAnnotatedType, String name, String methodName, List<Annotation> annotations, Map<Class<? extends Annotation>, Annotation> annotationsMap) {
        this.returnAnnotatedType = returnAnnotatedType;
        this.name = name;
        this.methodName = methodName;
        this.annotations = annotations;
        this.annotationsMap = annotationsMap;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.returnAnnotatedType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    @Override
    @Nullable
    public Object getValue(Object obj) {
        throw new UnsupportedOperationException("Interface method should not be called.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceJavaMethodProperty that = (InterfaceJavaMethodProperty)obj;
        return this.returnAnnotatedType.getType().equals(that.returnAnnotatedType.getType()) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.returnAnnotatedType.getType(), this.annotations);
    }
}

