/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyCache;
import com.navercorp.fixturemonkey.api.property.PropertyDescriptorProperty;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.5.3", status=API.Status.EXPERIMENTAL)
public final class JavaBeansPropertyGenerator
implements PropertyGenerator {
    private final Predicate<PropertyDescriptor> propertyDescriptorPredicate;
    private final Matcher matcher;

    public JavaBeansPropertyGenerator(Predicate<PropertyDescriptor> propertyDescriptorPredicate, Matcher matcher) {
        this.propertyDescriptorPredicate = propertyDescriptorPredicate;
        this.matcher = matcher;
    }

    @Override
    public List<Property> generateChildProperties(AnnotatedType annotatedType) {
        return PropertyCache.getPropertyDescriptorsByPropertyName(annotatedType).values().stream().filter(it -> it.getReadMethod() != null).filter(this.propertyDescriptorPredicate).map(PropertyDescriptorProperty::new).filter(this.matcher::match).collect(Collectors.toList());
    }
}

