/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class TypeCache {
    private static final Map<Field, AnnotatedType> FIELD_ANNOTATED_TYPE_MAP = new ConcurrentHashMap<Field, AnnotatedType>(2000);
    private static final Map<PropertyDescriptor, AnnotatedType> PROPERTY_DESCRIPTOR_ANNOTATED_TYPE_MAP = new ConcurrentHashMap<PropertyDescriptor, AnnotatedType>(2000);

    public static AnnotatedType getAnnotatedType(Field field) {
        return FIELD_ANNOTATED_TYPE_MAP.computeIfAbsent(field, Field::getAnnotatedType);
    }

    public static AnnotatedType getAnnotatedType(PropertyDescriptor propertyDescriptor) {
        return PROPERTY_DESCRIPTOR_ANNOTATED_TYPE_MAP.computeIfAbsent(propertyDescriptor, it -> it.getReadMethod().getAnnotatedReturnType());
    }
}

