/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.property.Traceable;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class MappedCombinableArbitrary<T, U>
implements CombinableArbitrary<U> {
    private final CombinableArbitrary<T> combinableArbitrary;
    private final Function<T, U> mapper;

    MappedCombinableArbitrary(CombinableArbitrary<T> combinableArbitrary, Function<T, U> mapper) {
        this.combinableArbitrary = combinableArbitrary;
        this.mapper = mapper;
    }

    @Override
    public U combined() {
        return this.mapper.apply(this.combinableArbitrary.combined());
    }

    @Override
    public U rawValue() {
        try {
            return this.mapper.apply(this.combinableArbitrary.rawValue());
        }
        catch (ClassCastException ex) {
            if (this.combinableArbitrary instanceof Traceable) {
                throw new ClassCastException(String.format("Given property '%s' could not use mapper. Check out if using the proper introspector.", ((Traceable)((Object)this.combinableArbitrary)).getPropertyPath().getExpression()));
            }
            throw new ClassCastException("Could not use mapper. Check out if using the proper introspector.");
        }
    }

    @Override
    public void clear() {
        this.combinableArbitrary.clear();
    }

    @Override
    public boolean fixed() {
        return this.combinableArbitrary.fixed();
    }
}

