/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.Traceable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryGeneratorContext
implements Traceable {
    private final Property resolvedProperty;
    private final ArbitraryProperty property;
    private final List<ArbitraryProperty> children;
    @Nullable
    private final ArbitraryGeneratorContext ownerContext;
    private final BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, CombinableArbitrary<?>> resolveArbitrary;
    private final MonkeyGeneratorContext monkeyGeneratorContext;
    private final LazyArbitrary<PropertyPath> pathProperty = LazyArbitrary.lazy(this::initPathProperty);
    private final LazyArbitrary<Map<ArbitraryProperty, CombinableArbitrary<?>>> arbitraryListByArbitraryProperty = LazyArbitrary.lazy(this::initArbitraryListByArbitraryProperty);
    private final int generateUniqueMaxTries;
    private final AtomicReference<CombinableArbitrary<?>> generated = new AtomicReference(CombinableArbitrary.NOT_GENERATED);

    public ArbitraryGeneratorContext(Property resolvedProperty, ArbitraryProperty property, List<ArbitraryProperty> children, @Nullable ArbitraryGeneratorContext ownerContext, BiFunction<ArbitraryGeneratorContext, ArbitraryProperty, CombinableArbitrary<?>> resolveArbitrary, MonkeyGeneratorContext monkeyGeneratorContext, int generateUniqueMaxTries) {
        this.resolvedProperty = resolvedProperty;
        this.property = property;
        this.children = new ArrayList<ArbitraryProperty>(children);
        this.ownerContext = ownerContext;
        this.resolveArbitrary = resolveArbitrary;
        this.monkeyGeneratorContext = monkeyGeneratorContext;
        this.generateUniqueMaxTries = generateUniqueMaxTries;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.property;
    }

    public Property getResolvedProperty() {
        return this.resolvedProperty;
    }

    public AnnotatedType getResolvedAnnotatedType() {
        return this.getResolvedProperty().getAnnotatedType();
    }

    public Type getResolvedType() {
        return this.getResolvedProperty().getType();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return this.getResolvedProperty().getAnnotation(annotationClass);
    }

    public List<ArbitraryProperty> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Map<ArbitraryProperty, CombinableArbitrary<?>> getCombinableArbitrariesByArbitraryProperty() {
        return this.arbitraryListByArbitraryProperty.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, CombinableArbitrary<?>> getCombinableArbitrariesByResolvedName() {
        return this.arbitraryListByArbitraryProperty.getValue().entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getResolvedPropertyName(), Map.Entry::getValue));
    }

    public Map<String, CombinableArbitrary<?>> getCombinableArbitrariesByPropertyName() {
        return this.arbitraryListByArbitraryProperty.getValue().entrySet().stream().collect(Collectors.toMap(it -> ((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty().getName(), Map.Entry::getValue));
    }

    public List<CombinableArbitrary<?>> getElementCombinableArbitraryList() {
        return new ArrayList(this.arbitraryListByArbitraryProperty.getValue().values());
    }

    @Nullable
    public ArbitraryGeneratorContext getOwnerContext() {
        return this.ownerContext;
    }

    public boolean isRootContext() {
        return this.property.getObjectProperty().isRoot();
    }

    public synchronized boolean isUniqueAndCheck(PropertyPath property, Object value) {
        return this.monkeyGeneratorContext.isUniqueAndCheck(property, value);
    }

    public void evictUnique(PropertyPath propertyPath) {
        this.monkeyGeneratorContext.evictUnique(propertyPath);
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.pathProperty.getValue();
    }

    public int getGenerateUniqueMaxTries() {
        return this.generateUniqueMaxTries;
    }

    public CombinableArbitrary<?> getGenerated() {
        return this.generated.get();
    }

    public void setGenerated(CombinableArbitrary<?> generated) {
        this.generated.set(generated);
    }

    private PropertyPath initPathProperty() {
        if (this.ownerContext == null) {
            return new PropertyPath(this.property.getObjectProperty().getProperty(), null, 1);
        }
        PropertyPath parentPropertyPath = this.ownerContext.getPropertyPath();
        return new PropertyPath(this.property.getObjectProperty().getProperty(), parentPropertyPath, parentPropertyPath.getDepth() + 1);
    }

    private Map<ArbitraryProperty, CombinableArbitrary<?>> initArbitraryListByArbitraryProperty() {
        LinkedHashMap childrenValues = new LinkedHashMap();
        for (ArbitraryProperty child : this.getChildren()) {
            CombinableArbitrary<?> arbitrary = this.resolveArbitrary.apply(this, child);
            childrenValues.put(child, arbitrary);
        }
        return childrenValues;
    }
}

