/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.6.2", status=API.Status.MAINTAINED)
public final class CompositeArbitraryGenerator
implements ArbitraryGenerator {
    private final List<ArbitraryGenerator> arbitraryGenerators;

    public CompositeArbitraryGenerator(List<ArbitraryGenerator> arbitraryGenerators) {
        this.arbitraryGenerators = arbitraryGenerators;
    }

    @Override
    public CombinableArbitrary<?> generate(ArbitraryGeneratorContext context) {
        CombinableArbitrary<?> generated = context.getGenerated();
        for (ArbitraryGenerator arbitraryGenerator : this.arbitraryGenerators) {
            generated = arbitraryGenerator.generate(context);
            context.setGenerated(generated);
        }
        return generated;
    }
}

