/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.instantiator;

import com.navercorp.fixturemonkey.api.instantiator.ConstructorInstantiator;
import com.navercorp.fixturemonkey.api.instantiator.FactoryMethodInstantiator;
import com.navercorp.fixturemonkey.api.instantiator.Instantiator;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessResult;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessor;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorUtils;
import com.navercorp.fixturemonkey.api.instantiator.JavaBeansPropertyInstantiator;
import com.navercorp.fixturemonkey.api.instantiator.JavaFieldPropertyInstantiator;
import com.navercorp.fixturemonkey.api.instantiator.PropertyInstantiator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.CompositeArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ConstructorArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.FactoryMethodArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.FieldReflectionArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.property.ConstructorParameterPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.ConstructorPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.FieldPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.JavaBeansPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.MethodParameterProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public final class JavaInstantiatorProcessor
implements InstantiatorProcessor {
    private static final ConstructorParameterPropertyGenerator JAVA_CONSTRUCTOR_PROPERTY_GENERATOR = new ConstructorParameterPropertyGenerator(it -> true, it -> true);

    @Override
    public InstantiatorProcessResult process(TypeReference<?> typeReference, Instantiator instantiator) {
        if (instantiator instanceof ConstructorInstantiator) {
            return this.processConstructor(typeReference, (ConstructorInstantiator)instantiator);
        }
        if (instantiator instanceof FactoryMethodInstantiator) {
            return this.processFactoryMethod(typeReference, (FactoryMethodInstantiator)instantiator);
        }
        if (instantiator instanceof JavaFieldPropertyInstantiator) {
            return this.processField(typeReference, (JavaFieldPropertyInstantiator)instantiator);
        }
        if (instantiator instanceof JavaBeansPropertyInstantiator) {
            return this.processJavaBeansProperty(typeReference, (JavaBeansPropertyInstantiator)instantiator);
        }
        throw new IllegalArgumentException("Given instantiator is not valid. instantiator: " + instantiator.getClass());
    }

    public InstantiatorProcessResult processConstructor(TypeReference<?> typeReference, ConstructorInstantiator<?> instantiator) {
        Class<?> type = Types.getActualType(typeReference.getType());
        List<TypeReference<?>> typeReferences = instantiator.getInputParameterTypes();
        Class[] arguments = (Class[])typeReferences.stream().map(it -> Types.getActualType(it.getType())).toArray(Class[]::new);
        Constructor<?> declaredConstructor = Types.getDeclaredConstructor(type, arguments);
        Property property = PropertyUtils.toProperty(typeReference);
        List<Property> constructorParameterProperties = JAVA_CONSTRUCTOR_PROPERTY_GENERATOR.generateParameterProperties(new ConstructorPropertyGeneratorContext(property, declaredConstructor, instantiator.getInputParameterTypes(), instantiator.getInputParameterNames()));
        List<String> parameterNames = constructorParameterProperties.stream().map(Property::getName).collect(Collectors.toList());
        ConstructorArbitraryIntrospector constructorArbitraryIntrospector = new ConstructorArbitraryIntrospector(new ConstructorArbitraryIntrospector.ConstructorWithParameterNames(declaredConstructor, parameterNames));
        PropertyInstantiator<?> propertyInstantiator = instantiator.getPropertyInstantiator();
        if (propertyInstantiator != null) {
            return this.processPropertyInstantiator(typeReference, propertyInstantiator, constructorArbitraryIntrospector, constructorParameterProperties);
        }
        return new InstantiatorProcessResult(constructorArbitraryIntrospector, constructorParameterProperties);
    }

    private InstantiatorProcessResult processFactoryMethod(TypeReference<?> typeReference, FactoryMethodInstantiator<?> instantiator) {
        Class<?> type = Types.getActualType(typeReference.getType());
        String factoryMethodName = instantiator.getFactoryMethodName();
        List<TypeReference<?>> inputTypeReferences = instantiator.getInputParameterTypes();
        List<String> inputParameterNames = instantiator.getInputParameterNames();
        Object[] inputParameterTypes = (Class[])inputTypeReferences.stream().map(it -> Types.getActualType(it.getType())).toArray(Class[]::new);
        Method factoryMethod = Arrays.stream(type.getDeclaredMethods()).filter(it -> it.getName().equals(factoryMethodName)).filter(it -> Modifier.isStatic(it.getModifiers())).filter(arg_0 -> JavaInstantiatorProcessor.lambda$processFactoryMethod$8((Class[])inputParameterTypes, arg_0)).findAny().orElse(null);
        if (factoryMethod == null) {
            throw new IllegalArgumentException("Given type method is not exists. name: " + factoryMethodName + " type: " + type + " inputParameterTypes: " + Arrays.toString(inputParameterTypes));
        }
        List<Property> properties = JavaInstantiatorProcessor.getMethodParameterProperties(factoryMethod, inputParameterNames, inputTypeReferences);
        List<String> parameterNames = properties.stream().map(Property::getName).collect(Collectors.toList());
        FactoryMethodArbitraryIntrospector factoryMethodArbitraryIntrospector = new FactoryMethodArbitraryIntrospector(new FactoryMethodArbitraryIntrospector.FactoryMethodWithParameterNames(factoryMethod, parameterNames));
        PropertyInstantiator<?> propertyInstantiator = instantiator.getPropertyInstantiator();
        if (propertyInstantiator != null) {
            return this.processPropertyInstantiator(typeReference, propertyInstantiator, factoryMethodArbitraryIntrospector, properties);
        }
        return new InstantiatorProcessResult(factoryMethodArbitraryIntrospector, properties);
    }

    private InstantiatorProcessResult processPropertyInstantiator(TypeReference<?> typeReference, PropertyInstantiator<?> propertyInstantiator, ArbitraryIntrospector formerArbitraryIntrospector, List<Property> formerProperties) {
        InstantiatorProcessResult propertyInstantiatorProcessResult = this.process(typeReference, propertyInstantiator);
        ArrayList<Property> resolvedProperties = new ArrayList<Property>(formerProperties);
        resolvedProperties.addAll(propertyInstantiatorProcessResult.getProperties());
        return new InstantiatorProcessResult(new CompositeArbitraryIntrospector(Arrays.asList(formerArbitraryIntrospector, propertyInstantiatorProcessResult.getIntrospector())), resolvedProperties);
    }

    private static List<Property> getMethodParameterProperties(Method factoryMethod, List<String> inputParameterNames, List<TypeReference<?>> inputTypeReferences) {
        Parameter[] parameters = factoryMethod.getParameters();
        List<TypeReference<?>> methodParameterTypeReferences = Arrays.stream(parameters).map(it -> Types.toTypeReference(it.getAnnotatedType())).collect(Collectors.toList());
        List<String> methodParameterNames = Arrays.stream(parameters).map(Parameter::getName).collect(Collectors.toList());
        List<TypeReference<?>> resolvedParameterTypes = InstantiatorUtils.resolveParameterTypes(methodParameterTypeReferences, inputTypeReferences);
        List<String> resolvedParameterNames = InstantiatorUtils.resolvedParameterNames(methodParameterNames, inputParameterNames);
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < parameters.length; ++i) {
            String resolvedParameterName = resolvedParameterNames.get(i);
            TypeReference<?> resolvedTypeReference = resolvedParameterTypes.get(i);
            properties.add(new MethodParameterProperty(resolvedTypeReference.getAnnotatedType(), resolvedParameterName, null));
        }
        return properties;
    }

    public InstantiatorProcessResult processField(TypeReference<?> typeReference, JavaFieldPropertyInstantiator<?> instantiator) {
        Property property = PropertyUtils.toProperty(typeReference);
        Predicate<Field> fieldPredicate = instantiator.getFieldPredicate();
        List<Property> properties = new FieldPropertyGenerator(fieldPredicate, it -> true).generateChildProperties(property);
        return new InstantiatorProcessResult(FieldReflectionArbitraryIntrospector.INSTANCE, properties);
    }

    public InstantiatorProcessResult processJavaBeansProperty(TypeReference<?> typeReference, JavaBeansPropertyInstantiator<?> instantiator) {
        Property property = PropertyUtils.toProperty(typeReference);
        Predicate<PropertyDescriptor> propertyDescriptorPredicate = instantiator.getPropertyDescriptorPredicate();
        List<Property> properties = new JavaBeansPropertyGenerator(propertyDescriptorPredicate, it -> true).generateChildProperties(property);
        return new InstantiatorProcessResult(FieldReflectionArbitraryIntrospector.INSTANCE, properties);
    }

    private static /* synthetic */ boolean lambda$processFactoryMethod$8(Class[] inputParameterTypes, Method it) {
        return inputParameterTypes.length == 0 || Types.isAssignableTypes(inputParameterTypes, it.getParameterTypes());
    }
}

