/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.InvocationHandlerBuilder;
import com.navercorp.fixturemonkey.api.property.MethodProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class AnonymousArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final AnonymousArbitraryIntrospector INSTANCE = new AnonymousArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        return new ArbitraryIntrospectorResult(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(arbitrariesByPropertyName -> {
            List<ArbitraryProperty> childrenProperties = context.getChildren();
            InvocationHandlerBuilder invocationHandlerBuilder = new InvocationHandlerBuilder(new HashMap<String, Object>());
            for (ArbitraryProperty arbitraryProperty : childrenProperties) {
                Property childProperty = arbitraryProperty.getObjectProperty().getProperty();
                if (!(childProperty instanceof MethodProperty)) continue;
                MethodProperty methodProperty = (MethodProperty)childProperty;
                Object combined = arbitrariesByPropertyName.get(arbitraryProperty);
                invocationHandlerBuilder.put(methodProperty.getMethodName(), combined);
            }
            if (invocationHandlerBuilder.isEmpty()) {
                return null;
            }
            return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, invocationHandlerBuilder.build()));
        }));
    }
}

