/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArrayIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        return Types.getActualType(property.getType()).isArray() || GenericArrayType.class.isAssignableFrom(property.getType().getClass());
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(context.getElementCombinableArbitraryList()).build(elements -> {
            ArrayBuilder arrayBuilder = new ArrayBuilder(Types.getArrayComponentType(property.getObjectProperty().getProperty().getAnnotatedType()), elements.size());
            for (Object element : elements) {
                arrayBuilder.add(element);
            }
            return arrayBuilder.build();
        }));
    }

    private static final class ArrayBuilder {
        private final List<Object> array = new ArrayList<Object>();
        private final Class<?> componentType;
        private final int size;

        public ArrayBuilder(Class<?> componentType, int size) {
            this.componentType = componentType;
            this.size = size;
        }

        ArrayBuilder add(Object value) {
            if (this.array.size() >= this.size) {
                return this;
            }
            this.array.add(value);
            return this;
        }

        Object build() {
            Object array = Array.newInstance(this.componentType, this.size);
            for (int i = 0; i < this.array.size(); ++i) {
                Array.set(array, i, this.array.get(i));
            }
            return array;
        }
    }
}

