/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.Matchers;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.random.Randoms;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class BooleanIntrospector
implements ArbitraryIntrospector,
Matcher {
    @Override
    public boolean match(Property property) {
        return Matchers.BOOLEAN_TYPE_MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        List<Boolean> booleans = Arrays.asList(true, false);
        return new ArbitraryIntrospectorResult(CombinableArbitrary.from(() -> (Boolean)booleans.get(Randoms.nextInt(2))));
    }
}

