/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public final class ConstructorArbitraryIntrospector
implements ArbitraryIntrospector {
    private final ConstructorWithParameterNames<?> constructorWithParamNames;

    public ConstructorArbitraryIntrospector(ConstructorWithParameterNames<?> constructorWithParamNames) {
        this.constructorWithParamNames = constructorWithParamNames;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(ConstructorArbitraryIntrospector.combine(this.constructorWithParamNames.getConstructor(), this.constructorWithParamNames.getParameterNames())));
    }

    private static Function<Map<ArbitraryProperty, Object>, Object> combine(Constructor<?> constructor, List<String> parameterNames) {
        int parameterSize = parameterNames.size();
        return propertyValuesByArbitraryProperty -> {
            HashMap valuesByResolvedName = new HashMap();
            propertyValuesByArbitraryProperty.forEach((key, value) -> valuesByResolvedName.put(key.getObjectProperty().getResolvedPropertyName(), value));
            ArrayList list = new ArrayList(parameterSize);
            for (String parameterName : parameterNames) {
                Object combined = valuesByResolvedName.getOrDefault(parameterName, null);
                list.add(combined);
            }
            return Reflections.newInstance(constructor, list.toArray());
        };
    }

    public static class ConstructorWithParameterNames<T> {
        private final Constructor<T> constructor;
        private final List<String> parameterNames;

        public ConstructorWithParameterNames(Constructor<T> constructor, List<String> parameterNames) {
            this.constructor = constructor;
            this.parameterNames = parameterNames;
        }

        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        public List<String> getParameterNames() {
            return this.parameterNames;
        }
    }
}

