/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Reflections;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public final class ConstructorPropertiesArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final ConstructorPropertiesArbitraryIntrospector INSTANCE = new ConstructorPropertiesArbitraryIntrospector();

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        Map.Entry<Constructor<?>, String[]> parameterNamesByConstructor = TypeCache.getParameterNamesByConstructor(type);
        if (parameterNamesByConstructor == null) {
            throw new IllegalArgumentException("Primary Constructor does not exist. type " + type.getSimpleName());
        }
        Constructor<?> primaryConstructor = parameterNamesByConstructor.getKey();
        String[] parameterNames = parameterNamesByConstructor.getValue();
        return new ArbitraryIntrospectorResult(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(ConstructorPropertiesArbitraryIntrospector.combine(primaryConstructor, parameterNames)));
    }

    private static Function<Map<ArbitraryProperty, Object>, Object> combine(Constructor<?> primaryConstructor, String[] parameterNames) {
        int parameterSize = parameterNames.length;
        return propertyValuesByArbitraryProperty -> {
            HashMap valuesByResolvedName = new HashMap();
            propertyValuesByArbitraryProperty.forEach((key, value) -> valuesByResolvedName.put(key.getObjectProperty().getResolvedPropertyName(), value));
            ArrayList list = new ArrayList(parameterSize);
            for (String parameterName : parameterNames) {
                Object combined = valuesByResolvedName.getOrDefault(parameterName, null);
                list.add(combined);
            }
            return Reflections.newInstance(primaryConstructor, list.toArray());
        };
    }
}

